<?php

use Illuminate\Support\Facades\Route;

/**
 * Script de test pour vérifier toutes les routes admin
 */

echo "=== TEST DES ROUTES ADMIN ===\n\n";

// Vérifier que toutes les routes admin existent
$adminRoutes = [
    'admin.dashboard',
    'admin.articles.index',
    'admin.articles.create', 
    'admin.articles.store',
    'admin.articles.show',
    'admin.articles.edit',
    'admin.articles.update',
    'admin.articles.destroy',
    'admin.projects.index',
    'admin.projects.create',
    'admin.projects.store',
    'admin.projects.show', 
    'admin.projects.edit',
    'admin.projects.update',
    'admin.projects.destroy',
    'admin.testimonials.index',
    'admin.testimonials.create',
    'admin.testimonials.store',
    'admin.testimonials.show',
    'admin.testimonials.edit', 
    'admin.testimonials.update',
    'admin.testimonials.destroy',
    'admin.partners.index',
    'admin.partners.create',
    'admin.partners.store',
    'admin.partners.show',
    'admin.partners.edit',
    'admin.partners.update', 
    'admin.partners.destroy',
    'admin.faqs.index',
    'admin.faqs.create',
    'admin.faqs.store',
    'admin.faqs.show',
    'admin.faqs.edit',
    'admin.faqs.update',
    'admin.faqs.destroy',
    'admin.documents.index',
    'admin.documents.create',
    'admin.documents.store',
    'admin.documents.show',
    'admin.documents.edit',
    'admin.documents.update',
    'admin.documents.destroy',
    'admin.pages.index',
    'admin.pages.create',
    'admin.pages.store', 
    'admin.pages.show',
    'admin.pages.edit',
    'admin.pages.update',
    'admin.pages.destroy',
    'admin.galleries.index',
    'admin.galleries.create',
    'admin.galleries.store',
    'admin.galleries.show',
    'admin.galleries.edit',
    'admin.galleries.update',
    'admin.galleries.destroy',
    'admin.settings.index',
    'admin.settings.create',
    'admin.settings.store',
    'admin.settings.show',
    'admin.settings.edit',
    'admin.settings.update',
    'admin.settings.destroy'
];

$missingRoutes = [];
$existingRoutes = [];

foreach ($adminRoutes as $routeName) {
    try {
        $route = Route::getRoutes()->getByName($routeName);
        if ($route) {
            $existingRoutes[] = $routeName;
        } else {
            $missingRoutes[] = $routeName;
        }
    } catch (Exception $e) {
        $missingRoutes[] = $routeName;
    }
}

echo "Routes existantes: " . count($existingRoutes) . "/" . count($adminRoutes) . "\n";
echo "Routes manquantes: " . count($missingRoutes) . "\n\n";

if (!empty($missingRoutes)) {
    echo "ROUTES MANQUANTES:\n";
    foreach ($missingRoutes as $route) {
        echo "- $route\n";
    }
    echo "\n";
}

// Test des modèles et des données
echo "=== TEST DES DONNÉES ===\n\n";

$models = [
    'Article' => \App\Models\Article::class,
    'Project' => \App\Models\Project::class,
    'Testimonial' => \App\Models\Testimonial::class,
    'Partner' => \App\Models\Partner::class,
    'Faq' => \App\Models\Faq::class,
    'Document' => \App\Models\Document::class,
    'Page' => \App\Models\Page::class,
    'Gallery' => \App\Models\Gallery::class,
    'Setting' => \App\Models\Setting::class,
];

foreach ($models as $name => $class) {
    try {
        $count = $class::count();
        $activeCount = method_exists($class, 'scopeActive') ? $class::active()->count() : 'N/A';
        echo "$name: $count total" . ($activeCount !== 'N/A' ? ", $activeCount actifs" : '') . "\n";
    } catch (Exception $e) {
        echo "$name: ERREUR - " . $e->getMessage() . "\n";
    }
}

echo "\n=== TEST DES SCOPES ===\n\n";

// Test des scopes spécifiques
try {
    echo "Articles publiés: " . \App\Models\Article::published()->count() . "\n";
    echo "Articles en vedette: " . \App\Models\Article::featured()->count() . "\n";
    echo "Projets en cours: " . \App\Models\Project::active()->count() . "\n";
    echo "Témoignages en vedette: " . \App\Models\Testimonial::featured()->count() . "\n";
    echo "Partenaires actifs: " . \App\Models\Partner::active()->count() . "\n";
    echo "FAQs actives: " . \App\Models\Faq::active()->count() . "\n";
    echo "Documents publics: " . \App\Models\Document::where('is_public', true)->count() . "\n";
    echo "Pages actives: " . \App\Models\Page::active()->count() . "\n";
    echo "Galeries actives: " . \App\Models\Gallery::active()->count() . "\n";
} catch (Exception $e) {
    echo "ERREUR dans les scopes: " . $e->getMessage() . "\n";
}

echo "\n=== TEST TERMINÉ ===\n";