<?php $__env->startSection('title', 'Gestion des Partenaires'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Gestion des Partenaires</h1>
            <a href="<?php echo e(route('admin.partners.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouveau Partenaire
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white border-b border-gray-200 px-6 py-4">
        <form method="GET" class="flex flex-wrap gap-4 items-end">
            <!-- Search -->
            <div class="flex-1 min-w-64">
                <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Rechercher</label>
                <input type="text" 
                       name="search" 
                       id="search" 
                       value="<?php echo e(request('search')); ?>"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                       placeholder="Nom ou description du partenaire...">
            </div>

            <!-- Type Filter -->
            <div class="min-w-48">
                <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                <select name="type" 
                        id="type" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Tous les types</option>
                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($type); ?>" <?php echo e(request('type') == $type ? 'selected' : ''); ?>>
                            <?php echo e(ucfirst($type)); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!-- Actions -->
            <div class="flex space-x-2">
                <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition duration-300">
                    Filtrer
                </button>
                <a href="<?php echo e(route('admin.partners.index')); ?>" class="bg-gray-400 text-white px-4 py-2 rounded-lg hover:bg-gray-500 transition duration-300">
                    Réinitialiser
                </a>
            </div>
        </form>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <!-- Success Message -->
        <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Error Message -->
        <?php if(session('error')): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <!-- Partners Grid -->
        <?php if($partners->count() > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden hover:shadow-lg transition duration-300">
                        <!-- Logo -->
                        <?php if($partner->logo_path): ?>
                            <div class="h-32 bg-gray-50 flex items-center justify-center p-4">
                                <img src="<?php echo e(asset('storage/' . $partner->logo_path)); ?>" 
                                     alt="<?php echo e($partner->name); ?>" 
                                     class="max-h-full max-w-full object-contain">
                            </div>
                        <?php else: ?>
                            <div class="h-32 bg-gray-100 flex items-center justify-center">
                                <svg class="w-16 h-16 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                </svg>
                            </div>
                        <?php endif; ?>

                        <!-- Content -->
                        <div class="p-4">
                            <!-- Header -->
                            <div class="flex items-start justify-between mb-2">
                                <h3 class="font-semibold text-lg text-gray-900 truncate"><?php echo e($partner->name); ?></h3>
                                <div class="flex items-center space-x-2 ml-2">
                                    <?php if($partner->is_featured ?? false): ?>
                                        <span class="bg-yellow-100 text-yellow-800 text-xs px-2 py-1 rounded-full">
                                            Vedette
                                        </span>
                                    <?php endif; ?>
                                    <?php if($partner->is_active): ?>
                                        <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full">
                                            Actif
                                        </span>
                                    <?php else: ?>
                                        <span class="bg-red-100 text-red-800 text-xs px-2 py-1 rounded-full">
                                            Inactif
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Type -->
                            <p class="text-sm text-blue-600 mb-2"><?php echo e(ucfirst($partner->type)); ?></p>

                            <!-- Description -->
                            <?php if($partner->description): ?>
                                <p class="text-gray-600 text-sm mb-3 line-clamp-2"><?php echo e(Str::limit($partner->description, 100)); ?></p>
                            <?php endif; ?>

                            <!-- Website -->
                            <?php if($partner->website_url): ?>
                                <div class="text-sm text-gray-500 mb-3">
                                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                    </svg>
                                    <a href="<?php echo e($partner->website_url); ?>" target="_blank" class="text-blue-600 hover:text-blue-800">
                                        Site web
                                    </a>
                                </div>
                            <?php endif; ?>

                            <!-- Actions -->
                            <div class="flex justify-between items-center pt-3 border-t border-gray-200">
                                <div class="flex space-x-2">
                                    <a href="<?php echo e(route('admin.partners.show', $partner)); ?>" 
                                       class="text-blue-600 hover:text-blue-800 text-sm">
                                        Voir
                                    </a>
                                    <a href="<?php echo e(route('admin.partners.edit', $partner)); ?>" 
                                       class="text-green-600 hover:text-green-800 text-sm">
                                        Modifier
                                    </a>
                                </div>
                                <form action="<?php echo e(route('admin.partners.destroy', $partner)); ?>" 
                                      method="POST" 
                                      class="inline"
                                      onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce partenaire ?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-800 text-sm">
                                        Supprimer
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <div class="mt-6">
                <?php echo e($partners->appends(request()->query())->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                </svg>
                <h3 class="text-xl font-medium text-gray-900 mb-2">Aucun partenaire trouvé</h3>
                <p class="text-gray-500 mb-4">
                    <?php if(request()->hasAny(['search', 'type'])): ?>
                        Aucun partenaire ne correspond à vos critères de recherche.
                    <?php else: ?>
                        Commencez par créer votre premier partenaire.
                    <?php endif; ?>
                </p>
                <a href="<?php echo e(route('admin.partners.create')); ?>" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Créer un Partenaire
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/curtis/Bureau/asu/resources/views/admin/partners/index.blade.php ENDPATH**/ ?>