<?php $__env->startSection('title', 'Accueil - Association Serment Universel'); ?>

<?php
use Illuminate\Support\Facades\Storage;
?>

<?php $__env->startSection('content'); ?>
<!-- Section Hero Simple -->
<section class="relative min-h-screen bg-gradient-to-br from-asu-600 to-asu-800 text-white"
         style="background-image: url('<?php echo e(asset("storage/images/cover1.jpeg")); ?>'); background-size: cover; background-position: center;">
    <div class="absolute inset-0 bg-black/40"></div>
    
    <div class="relative z-10 min-h-screen flex items-center">
        <div class="max-w-6xl mx-auto px-4 text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-6">
                Association <span class="text-yellow-300">Serment Universel</span>
            </h1>
            
            <p class="text-xl md:text-2xl mb-8 text-white/90 max-w-4xl mx-auto">
                <?php echo e($settings['site_description'] ?? 'Depuis 27 ans, nous œuvrons pour la prévention du VIH/SIDA et l\'accompagnement psychosocial en République du Congo'); ?>

            </p>
            
            <div class="flex flex-col sm:flex-row gap-4 justify-center mb-12">
                <a href="#nos-actions" class="bg-white text-asu-600 hover:bg-gray-100 font-semibold px-8 py-4 rounded-lg transition-all duration-300">
                    Découvrir nos actions
                </a>
                <a href="#" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 font-semibold px-8 py-4 rounded-lg transition-all duration-300">
                    En savoir plus
                </a>
            </div>
            
            <!-- Statistiques simples -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mt-16">
                <div class="text-center">
                    <div class="text-2xl font-bold text-yellow-300"><?php echo e($stats['years_active'] ?? 27); ?></div>
                    <div class="text-sm uppercase tracking-wide">Années d'expérience</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-yellow-300"><?php echo e($stats['articles_count'] ?? 50); ?></div>
                    <div class="text-sm uppercase tracking-wide">Articles publiés</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-yellow-300"><?php echo e($stats['projects_count'] ?? 15); ?></div>
                    <div class="text-sm uppercase tracking-wide">Projets réalisés</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-yellow-300"><?php echo e($stats['partners_count'] ?? 8); ?></div>
                    <div class="text-sm uppercase tracking-wide">Partenaires</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Section À Propos -->
<section id="a-propos" class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">À Propos de l'ASU</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Fondée en 1998, l'Association Serment Universel (ASU) a pour mission de placer l'humain au cœur de l'action solidaire.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div data-aos="fade-right">
                <h3 class="text-2xl font-bold text-gray-900 mb-6">Notre Mission</h3>
                <p class="text-gray-600 mb-6">
                    L'ASU œuvre dans la prévention du VIH/SIDA, l'accompagnement psychosocial des personnes affectées et infectées, ainsi que dans le développement communautaire en République du Congo.
                </p>
                
                <h4 class="text-xl font-semibold text-gray-900 mb-4">Nos Valeurs</h4>
                <ul class="space-y-3 text-gray-600">
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span><strong>Solidarité :</strong> Soutien mutuel et entraide communautaire</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span><strong>Respect :</strong> Dignité et acceptation de chaque personne</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span><strong>Engagement :</strong> Dévouement total à notre cause</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span><strong>Innovation :</strong> Approches créatives pour le changement</span>
                    </li>
                </ul>
            </div>
            
            <div data-aos="fade-left">
                <div class="relative">
                    <img src="<?php echo e(asset('storage/utiles/apropo1.jpeg')); ?>" alt="À propos de l'ASU" class="rounded-lg shadow-xl" onerror="this.style.display='none'">
                    <div class="absolute inset-0 bg-asu-600/20 rounded-lg"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Section Nos Actions -->
<section id="nos-actions" class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Actions</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Découvrez nos différents domaines d'intervention pour un impact durable dans nos communautés.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Action 1: Prévention VIH/SIDA -->
            <div class="bg-gradient-to-br from-red-50 to-red-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="100">
                <div class="w-12 h-12 bg-red-600 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">Prévention VIH/SIDA</h3>
                <p class="text-gray-600 text-sm mb-3">Sensibilisation, dépistage et accompagnement des personnes affectées par le VIH/SIDA.</p>
                <a href="#" class="text-red-600 hover:text-red-700 font-medium text-sm">En savoir plus →</a>
            </div>
            
            <!-- Action 2: Accompagnement Psychosocial -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="200">
                <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">Accompagnement Psychosocial</h3>
                <p class="text-gray-600 text-sm mb-3">Soutien émotionnel et social pour les personnes vulnérables et leurs familles.</p>
                <a href="#" class="text-blue-600 hover:text-blue-700 font-medium text-sm">En savoir plus →</a>
            </div>
            
            <!-- Action 3: Développement Communautaire -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="300">
                <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">Développement Communautaire</h3>
                <p class="text-gray-600 text-sm mb-3">Projets de développement durable pour améliorer les conditions de vie.</p>
                <a href="#" class="text-green-600 hover:text-green-700 font-medium text-sm">En savoir plus →</a>
            </div>
            
            <!-- Action 4: Formation et Éducation -->
            <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="400">
                <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mb-4">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-3">Formation et Éducation</h3>
                <p class="text-gray-600 text-sm mb-3">Programmes de formation et sensibilisation pour tous les âges.</p>
                <a href="#" class="text-purple-600 hover:text-purple-700 font-medium text-sm">En savoir plus →</a>
            </div>
        </div>
    </div>
</section>

<!-- Section Actualités -->
<?php if($latestArticles && $latestArticles->count() > 0): ?>
<section class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Actualités</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Restez informés de nos dernières actions et actualités.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $latestArticles->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" data-aos="fade-up" data-aos-delay="<?php echo e($loop->iteration * 100); ?>">
                    <?php if($article->featured_image): ?>
                        <img src="<?php echo e(asset('storage/' . $article->featured_image)); ?>" 
                             alt="<?php echo e($article->title); ?>"
                             class="w-full h-48 object-cover">
                    <?php else: ?>
                        <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center">
                            <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                            </svg>
                        </div>
                    <?php endif; ?>
                    
                    <div class="p-6">
                        <div class="text-sm text-asu-600 font-medium mb-2"><?php echo e($article->created_at->format('d M Y')); ?></div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3"><?php echo e($article->title); ?></h3>
                        <p class="text-gray-600 mb-4 line-clamp-3">
                            <?php echo e($article->excerpt ?? Str::limit(strip_tags($article->content), 120)); ?>

                        </p>
                        <a href="<?php echo e(route('article', $article->slug)); ?>" class="text-asu-600 hover:text-asu-700 font-medium">Lire la suite →</a>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="text-center mt-12">
            <a href="<?php echo e(route('actualites')); ?>" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                Voir toutes les actualités
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Section Témoignages -->
<?php if($featuredTestimonials && $featuredTestimonials->count() > 0): ?>
<section class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Témoignages</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Découvrez les témoignages de ceux qui ont bénéficié de nos actions et de nos partenaires.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $featuredTestimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow-lg p-6 relative">
                    <div class="absolute top-4 left-4 text-asu-200">
                        <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M14,17H17L19,13V7H13V13H16M6,17H9L11,13V7H5V13H8L6,17Z" />
                        </svg>
                    </div>
                    
                    <div class="pt-8">
                        <p class="text-gray-600 mb-6 italic"><?php echo e($testimonial->content); ?></p>
                        
                        <div class="flex items-center">
                            <div class="w-12 h-12 rounded-full overflow-hidden mr-4">
                                <?php if($testimonial->avatar): ?>
                                    <img src="<?php echo e(asset('storage/' . $testimonial->avatar)); ?>" 
                                         alt="<?php echo e($testimonial->name); ?>"
                                         class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full bg-asu-600 flex items-center justify-center">
                                        <span class="text-white font-bold text-lg"><?php echo e(substr($testimonial->name, 0, 1)); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <div class="font-semibold text-gray-900"><?php echo e($testimonial->name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($testimonial->position ?? 'Bénéficiaire'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Section Projets -->
<?php if($activeProjects && $activeProjects->count() > 0): ?>
<section class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Projets</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Découvrez nos projets en cours et leurs impacts sur les communautés.
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $activeProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group">
                    <div class="relative">
                        <?php if($project->featured_image): ?>
                            <img src="<?php echo e(Storage::url($project->featured_image)); ?>" 
                                 alt="<?php echo e($project->title); ?>" 
                                 class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                        <?php else: ?>
                            <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                                <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                </svg>
                            </div>
                        <?php endif; ?>
                        <div class="absolute top-4 right-4">
                            <span class="bg-asu-600 text-white px-3 py-1 rounded-full text-sm font-medium">
                                <?php echo e($project->status === 'active' ? 'En cours' : ucfirst($project->status)); ?>

                            </span>
                        </div>
                    </div>
                    
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-3"><?php echo e($project->title); ?></h3>
                        <p class="text-gray-600 mb-4 line-clamp-3">
                            <?php echo e($project->description ?? Str::limit(strip_tags($project->content), 120)); ?>

                        </p>
                        
                        <?php if($project->progress): ?>
                            <div class="mb-4">
                                <div class="flex justify-between text-sm text-gray-600 mb-2">
                                    <span>Progression</span>
                                    <span><?php echo e($project->progress); ?>%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-2">
                                    <div class="bg-asu-600 h-2 rounded-full" style="width: <?php echo e($project->progress); ?>%"></div>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <a href="<?php echo e(route('project', $project->slug)); ?>" class="text-asu-600 hover:text-asu-700 font-medium">En savoir plus →</a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="text-center mt-12">
            <a href="<?php echo e(route('projets')); ?>" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                Voir tous les projets
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Section FAQ -->
<section class="py-20 bg-white">
    <div class="max-w-4xl mx-auto px-4">
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Questions Fréquentes</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Trouvez rapidement des réponses aux questions les plus courantes sur nos services et actions.
            </p>
        </div>
        
        <?php if($featuredFaqs && $featuredFaqs->count() > 0): ?>
        <div class="space-y-6">
            <?php $__currentLoopData = $featuredFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow-md" data-aos="fade-up" data-aos-delay="<?php echo e($loop->iteration * 100); ?>">
                    <button class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-50 focus:outline-none focus:bg-gray-50" onclick="toggleFaq(<?php echo e($faq->id); ?>)">
                        <span class="font-semibold text-gray-900"><?php echo e($faq->question); ?></span>
                        <svg class="w-5 h-5 text-gray-500 transform transition-transform duration-200" id="faq-icon-<?php echo e($faq->id); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-4 hidden" id="faq-content-<?php echo e($faq->id); ?>">
                        <div class="text-gray-600 pt-2 border-t border-gray-100">
                            <?php echo $faq->answer; ?>

                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <p class="text-gray-500">Aucune question fréquente disponible pour le moment.</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Section Documents -->
<section class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Documents Utiles</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Téléchargez nos rapports, guides et documents informatifs.
            </p>
        </div>
        
        <?php if($featuredDocuments && $featuredDocuments->count() > 0): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php $__currentLoopData = $featuredDocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 p-6 group" data-aos="fade-up" data-aos-delay="<?php echo e($loop->iteration * 100); ?>">
                    <?php
                        $extension = pathinfo($document->file_path, PATHINFO_EXTENSION);
                        $colors = [
                            'pdf' => ['bg' => 'bg-red-100', 'hover' => 'group-hover:bg-red-200', 'text' => 'text-red-600', 'button' => 'bg-red-600 hover:bg-red-700'],
                            'doc' => ['bg' => 'bg-blue-100', 'hover' => 'group-hover:bg-blue-200', 'text' => 'text-blue-600', 'button' => 'bg-blue-600 hover:bg-blue-700'],
                            'docx' => ['bg' => 'bg-blue-100', 'hover' => 'group-hover:bg-blue-200', 'text' => 'text-blue-600', 'button' => 'bg-blue-600 hover:bg-blue-700'],
                            'zip' => ['bg' => 'bg-green-100', 'hover' => 'group-hover:bg-green-200', 'text' => 'text-green-600', 'button' => 'bg-green-600 hover:bg-green-700'],
                            'default' => ['bg' => 'bg-purple-100', 'hover' => 'group-hover:bg-purple-200', 'text' => 'text-purple-600', 'button' => 'bg-purple-600 hover:bg-purple-700']
                        ];
                        $color = $colors[$extension] ?? $colors['default'];
                    ?>
                    
                    <div class="flex items-center justify-center h-16 mb-4 <?php echo e($color['bg']); ?> <?php echo e($color['hover']); ?> rounded-lg transition-colors duration-300">
                        <svg class="w-8 h-8 <?php echo e($color['text']); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <?php if($extension === 'pdf'): ?>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            <?php elseif(in_array($extension, ['doc', 'docx'])): ?>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            <?php else: ?>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m5 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            <?php endif; ?>
                        </svg>
                    </div>
                    
                    <h3 class="text-lg font-bold text-gray-900 mb-2 line-clamp-2"><?php echo e($document->title); ?></h3>
                    <p class="text-sm text-gray-600 mb-4 line-clamp-3"><?php echo e($document->description); ?></p>
                    
                    <div class="flex items-center justify-between text-xs text-gray-500 mb-4">
                        <span><?php echo e(strtoupper($extension)); ?></span>
                        <span><?php echo e($document->created_at->format('d/m/Y')); ?></span>
                    </div>
                    
                    <a href="<?php echo e(Storage::url($document->file_path)); ?>" 
                       class="block w-full text-center <?php echo e($color['button']); ?> text-white font-medium py-2 px-4 rounded-lg transition-colors duration-300"
                       download>
                        Télécharger
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php else: ?>
        <div class="text-center py-12">
            <p class="text-gray-500">Aucun document disponible pour le moment.</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Section Galerie -->
<?php if($galleryImages && $galleryImages->count() > 0): ?>
<section class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Galerie</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Découvrez nos actions en images à travers notre galerie photo.
            </p>
        </div>
        
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
            <?php $__currentLoopData = $galleryImages->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer">
                    <img src="<?php echo e(Storage::url($image->image_path)); ?>" 
                         alt="<?php echo e($image->title); ?>" 
                         class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                    <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                        <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0zM10 7v3m0 0v3m0-3h3m-3 0H7"></path>
                        </svg>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="text-center mt-12">
            <a href="<?php echo e(route('galerie')); ?>" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                Voir toute la galerie
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Section Partenaires -->
<?php if($activePartners && $activePartners->count() > 0): ?>
<section class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Partenaires</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                Nous travaillons avec des partenaires de confiance pour maximiser notre impact.
            </p>
        </div>
        
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
            <?php $__currentLoopData = $activePartners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow-lg p-6 hover:shadow-xl transition-all duration-300 group">
                    <div class="flex items-center justify-center h-24 mb-4">
                        <?php if($partner->logo): ?>
                            <img src="<?php echo e(Storage::url($partner->logo)); ?>" 
                                 alt="<?php echo e($partner->name); ?>"
                                 class="max-h-full max-w-full object-contain group-hover:scale-110 transition-transform duration-300">
                        <?php else: ?>
                            <div class="w-16 h-16 bg-asu-600 rounded-lg flex items-center justify-center">
                                <span class="text-white font-bold text-xl"><?php echo e(substr($partner->name, 0, 1)); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 text-center mb-2"><?php echo e($partner->name); ?></h3>
                    <?php if($partner->description): ?>
                        <p class="text-sm text-gray-600 text-center"><?php echo e(Str::limit($partner->description, 80)); ?></p>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Section Contact -->
<section class="py-20 bg-asu-600 text-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold mb-4">Contactez-nous</h2>
            <p class="text-xl text-white/90 max-w-3xl mx-auto">
                N'hésitez pas à nous contacter pour toute question ou pour rejoindre nos actions.
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <div>
                <h3 class="text-2xl font-bold mb-8">Nos Coordonnées</h3>
                <div class="space-y-6">
                    <div class="flex items-start space-x-3">
                        <div>
                            <div class="font-medium">Adresse</div>
                            <div class="text-gray-300">123 Avenue de la Paix, Brazzaville, République du Congo</div>
                        </div>
                    </div>
                    <div class="flex items-start space-x-3">
                        <div>
                            <div class="font-medium">Téléphone</div>
                            <div class="text-gray-300">+242 05 123 45 67</div>
                        </div>
                    </div>
                    <div class="flex items-start space-x-3">
                        <div>
                            <div class="font-medium">Email</div>
                            <div class="text-gray-300">contact@asu-congo.org</div>
                        </div>
                    </div>
                </div>
                
                <!-- Réseaux sociaux -->
                <div class="mt-8">
                    <h4 class="font-medium mb-4">Suivez-nous</h4>
                    <div class="flex space-x-3">
                        <a href="https://facebook.com/asu.congo" class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center hover:bg-blue-700 transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        <a href="https://youtube.com/c/asucongo" class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center hover:bg-red-700 transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                            </svg>
                        </a>
                        <a href="https://instagram.com/asu_congo" class="w-10 h-10 bg-pink-600 rounded-lg flex items-center justify-center hover:bg-pink-700 transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                        <a href="https://linkedin.com/company/asu-congo" class="w-10 h-10 bg-blue-800 rounded-lg flex items-center justify-center hover:bg-blue-900 transition-colors">
                            <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            
            <div data-aos="fade-left">
                <form class="space-y-6" action="#" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="name" class="block text-sm font-medium mb-2">Nom complet</label>
                            <input type="text" id="name" name="name" required
                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50">
                        </div>
                        <div>
                            <label for="email" class="block text-sm font-medium mb-2">Email</label>
                            <input type="email" id="email" name="email" required
                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50">
                        </div>
                    </div>
                    
                    <div>
                        <label for="subject" class="block text-sm font-medium mb-2">Sujet</label>
                        <input type="text" id="subject" name="subject" required
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50">
                    </div>
                    
                    <div>
                        <label for="message" class="block text-sm font-medium mb-2">Message</label>
                        <textarea id="message" name="message" rows="5" required
                                  class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50 resize-none"></textarea>
                    </div>
                    
                    <button type="submit" 
                            class="w-full bg-white text-asu-600 hover:bg-gray-100 font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                        Envoyer le message
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Statistiques -->
<section class="bg-gray-100 py-16">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12" data-aos="fade-up">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">Notre impact en chiffres</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Découvrez l'impact concret de nos actions sur le terrain</p>
        </div>
        
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            <div class="text-center" data-aos="fade-up" data-aos-delay="100">
                <div class="bg-white rounded-lg p-6 shadow-lg">
                    <div class="text-3xl font-bold text-green-600 mb-2 counter" data-target="<?php echo e($allProjects->count()); ?>">0</div>
                    <p class="text-gray-600">Projets réalisés</p>
                </div>
            </div>
            
            <div class="text-center" data-aos="fade-up" data-aos-delay="200">
                <div class="bg-white rounded-lg p-6 shadow-lg">
                    <div class="text-3xl font-bold text-blue-600 mb-2 counter" data-target="<?php echo e($allArticles->count()); ?>">0</div>
                    <p class="text-gray-600">Articles publiés</p>
                </div>
            </div>
            
            <div class="text-center" data-aos="fade-up" data-aos-delay="300">
                <div class="bg-white rounded-lg p-6 shadow-lg">
                    <div class="text-3xl font-bold text-purple-600 mb-2 counter" data-target="<?php echo e($allPartners->count()); ?>">0</div>
                    <p class="text-gray-600">Partenaires</p>
                </div>
            </div>
            
            <div class="text-center" data-aos="fade-up" data-aos-delay="400">
                <div class="bg-white rounded-lg p-6 shadow-lg">
                    <div class="text-3xl font-bold text-orange-600 mb-2 counter" data-target="500">0</div>
                    <p class="text-gray-600">Bénéficiaires</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter -->
<section class="bg-green-600 py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto text-center" data-aos="fade-up">
            <h2 class="text-3xl font-bold text-white mb-4">Restez informé de nos actions</h2>
            <p class="text-green-100 mb-8">Inscrivez-vous à notre newsletter pour recevoir nos dernières actualités et projets</p>
            
            <form class="max-w-md mx-auto flex gap-3" id="newsletter-form">
                <input type="email" 
                       placeholder="Votre adresse email" 
                       class="flex-1 px-4 py-3 rounded-lg border-0 focus:ring-2 focus:ring-white focus:outline-none"
                       required>
                <button type="submit" 
                        class="px-6 py-3 bg-white text-green-600 font-semibold rounded-lg hover:bg-gray-100 transition-colors">
                    S'abonner
                </button>
            </form>
            
            <p class="text-green-100 text-sm mt-4">Vos données sont protégées et ne seront jamais partagées</p>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('head'); ?>
<!-- AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<!-- AOS JavaScript -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script>
    // Initialisation AOS
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true,
        mirror: false
    });
    
    // Animation des compteurs
    function animateCounter(element) {
        const target = parseInt(element.getAttribute('data-target'));
        const increment = target / 200;
        let current = 0;
        
        const timer = setInterval(() => {
            current += increment;
            element.textContent = Math.floor(current);
            
            if (current >= target) {
                element.textContent = target;
                clearInterval(timer);
            }
        }, 10);
    }
    
    // Observer pour démarrer l'animation quand visible
    const statsCounters = document.querySelectorAll('.counter');
    if (statsCounters.length > 0) {
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const counters = entry.target.querySelectorAll('.counter');
                    counters.forEach(counter => {
                        animateCounter(counter);
                    });
                    observer.unobserve(entry.target);
                }
            });
        });
        
        observer.observe(statsCounters[0].closest('section'));
    }
    
    // Smooth scroll pour les liens d'ancrage
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // Lightbox simple pour la galerie
    document.querySelectorAll('.group.cursor-pointer').forEach(item => {
        item.addEventListener('click', function() {
            const img = this.querySelector('img');
            if (img) {
                // Créer une lightbox simple
                const lightbox = document.createElement('div');
                lightbox.innerHTML = `
                    <div class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 p-4" onclick="this.parentElement.remove()">
                        <div class="max-w-4xl max-h-full">
                            <img src="${img.src}" alt="${img.alt}" class="max-w-full max-h-full object-contain rounded-lg">
                            <div class="text-center mt-4">
                                <button class="bg-white text-black px-4 py-2 rounded" onclick="this.closest('.fixed').parentElement.remove()">Fermer</button>
                            </div>
                        </div>
                    </div>
                `;
                document.body.appendChild(lightbox);
            }
        });
    });
    
    // Toggle FAQ
    function toggleFaq(id) {
        const content = document.getElementById('faq-content-' + id);
        const icon = document.getElementById('faq-icon-' + id);
        
        if (content.classList.contains('hidden')) {
            content.classList.remove('hidden');
            icon.style.transform = 'rotate(180deg)';
        } else {
            content.classList.add('hidden');
            icon.style.transform = 'rotate(0deg)';
        }
    }
    
    // Newsletter form
    document.getElementById('newsletter-form').addEventListener('submit', function(e) {
        e.preventDefault();
        const email = this.querySelector('input[type="email"]').value;
        
        // Simulation d'envoi (à remplacer par votre logique)
        alert('Merci pour votre inscription ! Vous recevrez bientôt nos actualités.');
        this.reset();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.asu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/curtis/Bureau/asu/resources/views/welcome.blade.php ENDPATH**/ ?>