<?php $__env->startSection('title', 'Détails du Partenaire'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Détails du Partenaire</h1>
            <div class="flex space-x-3">
                <a href="<?php echo e(route('admin.partners.edit', $partner)); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Modifier
                </a>
                <a href="<?php echo e(route('admin.partners.index')); ?>" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                    Retour à la liste
                </a>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-4xl mx-auto">
            <div class="bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                <!-- Header with Logo -->
                <div class="bg-gray-50 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center space-x-4">
                        <?php if($partner->logo_path): ?>
                            <div class="flex-shrink-0">
                                <img src="<?php echo e(asset('storage/' . $partner->logo_path)); ?>" 
                                     alt="<?php echo e($partner->name); ?>" 
                                     class="w-16 h-16 object-contain rounded-lg bg-white p-2">
                            </div>
                        <?php endif; ?>
                        <div class="flex-1">
                            <h2 class="text-2xl font-bold text-gray-900"><?php echo e($partner->name); ?></h2>
                            <div class="flex items-center space-x-4 mt-2">
                                <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
                                    <?php echo e(ucfirst($partner->type)); ?>

                                </span>
                                <?php if($partner->partnership_level ?? false): ?>
                                    <span class="bg-purple-100 text-purple-800 px-3 py-1 rounded-full text-sm font-medium">
                                        <?php echo e(ucfirst($partner->partnership_level)); ?>

                                    </span>
                                <?php endif; ?>
                                <?php if($partner->is_featured ?? false): ?>
                                    <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-medium">
                                        Partenaire vedette
                                    </span>
                                <?php endif; ?>
                                <span class="px-3 py-1 rounded-full text-sm font-medium <?php echo e($partner->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                    <?php echo e($partner->is_active ? 'Actif' : 'Inactif'); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Left Column -->
                        <div class="space-y-6">
                            <!-- Description -->
                            <?php if($partner->description): ?>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Description</h3>
                                    <div class="prose prose-sm text-gray-600">
                                        <?php echo nl2br(e($partner->description)); ?>

                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Contact Information -->
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-3">Informations de contact</h3>
                                <div class="space-y-3">
                                    <?php if($partner->website_url): ?>
                                        <div class="flex items-center">
                                            <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                            </svg>
                                            <a href="<?php echo e($partner->website_url); ?>" target="_blank" class="text-blue-600 hover:text-blue-800">
                                                <?php echo e($partner->website_url); ?>

                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($partner->contact_person ?? false): ?>
                                        <div class="flex items-center">
                                            <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                            </svg>
                                            <span class="text-gray-900"><?php echo e($partner->contact_person); ?></span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($partner->contact_email ?? false): ?>
                                        <div class="flex items-center">
                                            <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                            </svg>
                                            <a href="mailto:<?php echo e($partner->contact_email); ?>" class="text-blue-600 hover:text-blue-800">
                                                <?php echo e($partner->contact_email); ?>

                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($partner->contact_phone ?? false): ?>
                                        <div class="flex items-center">
                                            <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                            </svg>
                                            <a href="tel:<?php echo e($partner->contact_phone); ?>" class="text-blue-600 hover:text-blue-800">
                                                <?php echo e($partner->contact_phone); ?>

                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column -->
                        <div class="space-y-6">
                            <!-- Partnership Dates -->
                            <?php if($partner->partnership_start || $partner->partnership_end): ?>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Période de partenariat</h3>
                                    <div class="space-y-2">
                                        <?php if($partner->partnership_start): ?>
                                            <div class="flex items-center">
                                                <span class="text-gray-600 font-medium w-20">Début:</span>
                                                <span class="text-gray-900"><?php echo e($partner->partnership_start->format('d/m/Y')); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($partner->partnership_end): ?>
                                            <div class="flex items-center">
                                                <span class="text-gray-600 font-medium w-20">Fin:</span>
                                                <span class="text-gray-900"><?php echo e($partner->partnership_end->format('d/m/Y')); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Collaboration Areas -->
                            <?php if($partner->collaboration_areas && count($partner->collaboration_areas) > 0): ?>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Domaines de collaboration</h3>
                                    <div class="flex flex-wrap gap-2">
                                        <?php $__currentLoopData = $partner->collaboration_areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="bg-gray-100 text-gray-800 px-3 py-1 rounded-full text-sm">
                                                <?php echo e($area); ?>

                                            </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Metadata -->
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-3">Informations système</h3>
                                <div class="space-y-2 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Ordre d'affichage:</span>
                                        <span class="text-gray-900"><?php echo e($partner->order ?? 0); ?></span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Créé le:</span>
                                        <span class="text-gray-900"><?php echo e($partner->created_at->format('d/m/Y à H:i')); ?></span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Modifié le:</span>
                                        <span class="text-gray-900"><?php echo e($partner->updated_at->format('d/m/Y à H:i')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    <div class="flex justify-between">
                        <form action="<?php echo e(route('admin.partners.destroy', $partner)); ?>" 
                              method="POST" 
                              onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce partenaire ? Cette action est irréversible.')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition duration-300">
                                Supprimer ce partenaire
                            </button>
                        </form>

                        <div class="flex space-x-3">
                            <a href="<?php echo e(route('admin.partners.edit', $partner)); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                                Modifier
                            </a>
                            <a href="<?php echo e(route('admin.partners.index')); ?>" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                                Retour à la liste
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/curtis/Bureau/asu/resources/views/admin/partners/show.blade.php ENDPATH**/ ?>