<?php $__env->startSection('title', 'Actualités - Association Serment Universel'); ?>

<?php $__env->startSection('head'); ?>
<!-- AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="bg-gradient-to-r from-green-600 to-green-800 text-white py-20"
        style="background-image: url('<?php echo e(asset("storage/images/cover1.jpeg")); ?>'); background-size: cover; background-position: center;">
    <div class="max-w-6xl mx-auto px-4 text-center">
        <h1 class="text-4xl md:text-5xl font-bold mb-4" data-aos="fade-up">Actualités</h1>
        <p class="text-xl text-white/90 max-w-2xl mx-auto" data-aos="fade-up" data-aos-delay="200">
            Suivez nos dernières actions et initiatives en République du Congo
        </p>
    </div>
</section>

<!-- Filters Section -->
<section class="py-8 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <form method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Rechercher</label>
                <input type="text" 
                       name="search" 
                       id="search" 
                       value="<?php echo e(request('search')); ?>" 
                       placeholder="Tapez votre recherche..." 
                       class="w-full border-gray-300 rounded-lg shadow-sm focus:ring-green-500 focus:border-green-500">
            </div>
            <div>
                <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Catégorie</label>
                <select name="category" 
                        id="category" 
                        class="border-gray-300 rounded-lg shadow-sm focus:ring-green-500 focus:border-green-500">
                    <option value="">Toutes les catégories</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category); ?>" <?php echo e(request('category') == $category ? 'selected' : ''); ?>>
                            <?php echo e(ucfirst($category)); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <button type="submit" 
                        class="bg-green-600 hover:bg-green-700 text-white font-medium px-6 py-2 rounded-lg transition-colors duration-200">
                    Filtrer
                </button>
            </div>
        </form>
    </div>
</section>

<!-- Articles à la une -->
<?php if($featuredArticles->count() > 0 && !request('search') && !request('category')): ?>
<section class="py-12 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <h2 class="text-2xl font-bold text-gray-900 mb-8" data-aos="fade-up">Articles à la une</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php $__currentLoopData = $featuredArticles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                    <?php if($article->featured_image): ?>
                        <img src="<?php echo e(asset('storage/' . $article->featured_image)); ?>" 
                             alt="<?php echo e($article->title); ?>" 
                             class="w-full h-48 object-cover">
                    <?php else: ?>
                        <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center">
                            <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                            </svg>
                        </div>
                    <?php endif; ?>
                    <div class="p-6">
                        <div class="flex items-center mb-3">
                            <span class="inline-block bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full mr-3">
                                ⭐ À la une
                            </span>
                            <span class="text-sm text-green-600 font-medium"><?php echo e($article->created_at->format('d M Y')); ?></span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3 hover:text-green-600 transition-colors">
                            <a href="<?php echo e(route('article', $article->slug)); ?>"><?php echo e($article->title); ?></a>
                        </h3>
                        <p class="text-gray-600 mb-4">
                            <?php echo e($article->excerpt ?: Str::limit(strip_tags($article->content), 120)); ?>

                        </p>
                        <div class="flex items-center justify-between">
                            <span class="inline-block bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                                <?php echo e(ucfirst($article->category)); ?>

                            </span>
                            <a href="<?php echo e(route('article', $article->slug)); ?>" 
                               class="text-green-600 hover:text-green-700 font-medium">
                                Lire la suite →
                            </a>
                        </div>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Tous les articles -->
<section class="py-12 <?php echo e($featuredArticles->count() > 0 && !request('search') && !request('category') ? 'bg-gray-50' : 'bg-white'); ?>">
    <div class="max-w-6xl mx-auto px-4">
        <div class="flex items-center justify-between mb-8">
            <h2 class="text-2xl font-bold text-gray-900" data-aos="fade-up">
                <?php echo e(request('search') || request('category') ? 'Résultats de recherche' : 'Tous les articles'); ?>

            </h2>
            <?php if(request('search') || request('category')): ?>
                <a href="<?php echo e(route('actualites')); ?>" 
                   class="text-green-600 hover:text-green-700 font-medium">
                    Voir tous les articles
                </a>
            <?php endif; ?>
        </div>

        <?php if($articles->count() > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" data-aos="fade-up" data-aos-delay="<?php echo e(($index % 6) * 100); ?>">
                        <?php if($article->featured_image): ?>
                            <img src="<?php echo e(asset('storage/' . $article->featured_image)); ?>" 
                                 alt="<?php echo e($article->title); ?>" 
                                 class="w-full h-48 object-cover">
                        <?php else: ?>
                            <div class="w-full h-48 bg-gradient-to-br from-green-500 to-green-700 flex items-center justify-center">
                                <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />
                                </svg>
                            </div>
                        <?php endif; ?>
                        <div class="p-6">
                            <div class="flex items-center mb-3">
                                <?php if($article->featured): ?>
                                    <span class="inline-block bg-yellow-100 text-yellow-800 text-xs font-medium px-2.5 py-0.5 rounded-full mr-3">
                                        ⭐ À la une
                                    </span>
                                <?php endif; ?>
                                <span class="text-sm text-green-600 font-medium"><?php echo e($article->created_at->format('d M Y')); ?></span>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-3 hover:text-green-600 transition-colors">
                                <a href="<?php echo e(route('article', $article->slug)); ?>"><?php echo e($article->title); ?></a>
                            </h3>
                            <p class="text-gray-600 mb-4">
                                <?php echo e($article->excerpt ?: Str::limit(strip_tags($article->content), 120)); ?>

                            </p>
                            <div class="flex items-center justify-between">
                                <span class="inline-block bg-green-100 text-green-800 text-xs font-medium px-2.5 py-0.5 rounded-full">
                                    <?php echo e(ucfirst($article->category)); ?>

                                </span>
                                <a href="<?php echo e(route('article', $article->slug)); ?>" 
                                   class="text-green-600 hover:text-green-700 font-medium">
                                    Lire la suite →
                                </a>
                            </div>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <?php if($articles->hasPages()): ?>
                <div class="mt-12 flex justify-center" data-aos="fade-up">
                    <?php echo e($articles->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="text-center py-12" data-aos="fade-up">
                <svg class="mx-auto h-12 w-12 text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucun article trouvé</h3>
                <?php if(request('search') || request('category')): ?>
                    <p class="text-gray-500 mb-4">Essayez de modifier vos critères de recherche.</p>
                    <a href="<?php echo e(route('actualites')); ?>" 
                       class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
                        Voir tous les articles
                    </a>
                <?php else: ?>
                    <p class="text-gray-500">Aucun article n'a encore été publié.</p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<!-- AOS JS -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true,
        mirror: false
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.asu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/curtis/Bureau/asu/resources/views/articles.blade.php ENDPATH**/ ?>