<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\ArticleController;
use App\Http\Controllers\Admin\ProjectController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\GalleryController;
use App\Http\Controllers\Admin\DocumentController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\PartnerController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\PageController;
use Illuminate\Support\Facades\Route;

// Routes publiques
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/actualites', [HomeController::class, 'articles'])->name('actualites');
Route::get('/actualites/{slug}', [HomeController::class, 'article'])->name('article');
Route::get('/projets', [HomeController::class, 'projects'])->name('projets');
Route::get('/projets/{slug}', [HomeController::class, 'project'])->name('project');
Route::get('/a-propos', [HomeController::class, 'about'])->name('about');
Route::get('/contact', [HomeController::class, 'contact'])->name('contact');
Route::get('/galerie', [HomeController::class, 'gallery'])->name('gallery');
Route::get('/documents', [HomeController::class, 'documents'])->name('documents');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Routes d'administration
Route::prefix('admin')->name('admin.')->middleware(['auth'])->group(function () {
    // Dashboard admin
    Route::get('/', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Articles
    Route::resource('articles', ArticleController::class);
    Route::post('articles/{article}/toggle-featured', [ArticleController::class, 'toggleFeatured'])->name('articles.toggle-featured');
    Route::post('articles/bulk-action', [ArticleController::class, 'bulkAction'])->name('articles.bulk-action');
    
    // Projets
    Route::resource('projects', ProjectController::class);
    Route::patch('projects/{project}/progress', [ProjectController::class, 'updateProgress'])->name('projects.update-progress');
    Route::post('projects/bulk-action', [ProjectController::class, 'bulkAction'])->name('projects.bulk-action');
    
    // Témoignages
    Route::resource('testimonials', TestimonialController::class);
    Route::post('testimonials/{testimonial}/toggle-featured', [TestimonialController::class, 'toggleFeatured'])->name('testimonials.toggle-featured');
    Route::post('testimonials/bulk-action', [TestimonialController::class, 'bulkAction'])->name('testimonials.bulk-action');
    
    // Galerie
    Route::resource('galleries', GalleryController::class);
    Route::post('galleries/bulk-upload', [GalleryController::class, 'bulkUpload'])->name('galleries.bulk-upload');
    Route::post('galleries/reorder', [GalleryController::class, 'reorder'])->name('galleries.reorder');
    Route::post('galleries/bulk-action', [GalleryController::class, 'bulkAction'])->name('galleries.bulk-action');
    
    // Documents
    Route::resource('documents', DocumentController::class);
    Route::get('documents/{document}/download', [DocumentController::class, 'download'])->name('documents.download');
    Route::post('documents/{document}/toggle-public', [DocumentController::class, 'togglePublic'])->name('documents.toggle-public');
    Route::post('documents/bulk-upload', [DocumentController::class, 'bulkUpload'])->name('documents.bulk-upload');
    Route::post('documents/bulk-action', [DocumentController::class, 'bulkAction'])->name('documents.bulk-action');
    
    // FAQ
    Route::resource('faqs', FaqController::class);
    Route::post('faqs/reorder', [FaqController::class, 'reorder'])->name('faqs.reorder');
    Route::post('faqs/{faq}/toggle-featured', [FaqController::class, 'toggleFeatured'])->name('faqs.toggle-featured');
    Route::post('faqs/bulk-action', [FaqController::class, 'bulkAction'])->name('faqs.bulk-action');
    
    // Partenaires
    Route::resource('partners', PartnerController::class);
    Route::post('partners/reorder', [PartnerController::class, 'reorder'])->name('partners.reorder');
    Route::post('partners/{partner}/toggle-active', [PartnerController::class, 'toggleActive'])->name('partners.toggle-active');
    Route::post('partners/bulk-action', [PartnerController::class, 'bulkAction'])->name('partners.bulk-action');
    
    // Paramètres
    Route::resource('settings', SettingController::class);
    Route::post('settings/bulk-update', [SettingController::class, 'bulkUpdate'])->name('settings.bulk-update');
    Route::post('settings/clear-cache', [SettingController::class, 'clearCache'])->name('settings.clear-cache');
    
    // Pages
    Route::resource('pages', PageController::class);
    Route::post('pages/reorder', [PageController::class, 'reorder'])->name('pages.reorder');
    Route::post('pages/{page}/toggle-menu', [PageController::class, 'toggleMenu'])->name('pages.toggle-menu');
    Route::post('pages/{page}/duplicate', [PageController::class, 'duplicate'])->name('pages.duplicate');
    Route::post('pages/bulk-action', [PageController::class, 'bulkAction'])->name('pages.bulk-action');
});

// API publique pour les paramètres
Route::get('/api/settings', [SettingController::class, 'getPublicSettings']);

require __DIR__.'/auth.php';
