@extends('layouts.asu')

@section('title', 'Accueil - Association Serment Universel')

@section('content')
<!-- Section Hero -->
<section class="relative min-h-screen bg-gradient-to-br from-asu-600 to-asu-800 text-white">
    <div class="absolute inset-0 bg-black/20"></div>
    
    <div class="relative z-10 min-h-screen flex items-center">
        <div class="max-w-6xl mx-auto px-4 text-center">
            <!-- Logo/Icon -->
            <div class="mb-8">
                <div class="w-24 h-24 mx-auto bg-white/20 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-12 h-12 text-white" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>
                    </svg>
                </div>
            </div>
            
            <!-- Titre principal -->
            <h1 class="text-4xl md:text-6xl font-bold mb-6">
                Association <span class="text-yellow-300">Serment Universel</span>
            </h1>
            
            <!-- Sous-titre -->
            <p class="text-xl md:text-2xl mb-8 text-white/90 max-w-4xl mx-auto">
                Depuis {{ age_since_founded() }} ans, nous œuvrons pour la prévention du VIH/SIDA 
                et l'accompagnement psychosocial en République du Congo
            </p>
            
            <!-- Boutons d'action -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center mb-12">
                <a href="#nos-actions" class="bg-white text-asu-600 hover:bg-gray-100 font-semibold px-8 py-4 rounded-lg transition-colors duration-300">
                    Découvrir nos actions
                </a>
                <a href="#a-propos" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 font-semibold px-8 py-4 rounded-lg transition-all duration-300">
                    En savoir plus
                </a>
            </div>
            
            <!-- Statistiques rapides -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-3xl mx-auto text-center">
                <div>
                    <div class="text-2xl font-bold text-yellow-300">{{ age_since_founded() }}</div>
                    <div class="text-sm text-white/80">Années</div>
                </div>
                <div>
                    <div class="text-2xl font-bold text-yellow-300">{{ asu_stats('communities_served') }}+</div>
                    <div class="text-sm text-white/80">Communautés</div>
                </div>
                <div>
                    <div class="text-2xl font-bold text-yellow-300">{{ format_large_number(asu_stats('people_helped')) }}+</div>
                    <div class="text-sm text-white/80">Personnes</div>
                </div>
                <div>
                    <div class="text-2xl font-bold text-yellow-300">{{ asu_stats('volunteers') }}+</div>
                    <div class="text-sm text-white/80">Bénévoles</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Indicateur de scroll -->
    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
        </svg>
    </div>
</section>

<!-- Section À propos -->
<section id="a-propos" class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Texte -->
            <div>
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">À propos de l'ASU</h2>
                
                <div class="space-y-4 text-gray-700 leading-relaxed">
                    <p class="text-lg">
                        Créée en <strong>{{ asu_config('founding_year') }}</strong>, l'Association Serment Universel (ASU) 
                        est une organisation non gouvernementale congolaise dédiée à la lutte contre le VIH/SIDA 
                        et à l'accompagnement psychosocial des personnes affectées à Brazzaville.
                    </p>
                    <p>
                        Notre mission est de <strong>{{ asu_config('mission') }}</strong>, 
                        en mettant l'accent sur la prévention, l'éducation et le soutien communautaire.
                    </p>
                    <p>
                        Nous croyons fermement que chaque personne mérite d'être accompagnée avec dignité 
                        et respect, sans discrimination aucune.
                    </p>
                </div>
                
                <!-- Valeurs -->
                <div class="mt-8">
                    <h3 class="text-xl font-bold text-gray-900 mb-4">Nos valeurs</h3>
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                        @foreach(asu_config('values') as $value)
                        <div class="flex items-center space-x-2">
                            <div class="w-2 h-2 bg-asu-600 rounded-full"></div>
                            <span class="text-gray-700">{{ $value }}</span>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            
            <!-- Image -->
            <div class="relative">
                <img src="https://images.unsplash.com/photo-1559027615-cd4628902d4a?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                     alt="Équipe ASU Brazzaville" 
                     class="rounded-lg shadow-lg w-full">
                <div class="absolute inset-0 bg-asu-600/20 rounded-lg"></div>
            </div>
        </div>
    </div>
</section>

<!-- Section Nos Actions -->
<section id="nos-actions" class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <!-- En-tête de section -->
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Actions</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Découvrez les domaines dans lesquels nous intervenons pour soutenir les communautés de Brazzaville
            </p>
        </div>
        
        <!-- Grille des actions -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            @foreach(asu_config('actions') as $key => $action)
            <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300 p-6 text-center">
                <!-- Icône -->
                <div class="w-16 h-16 bg-asu-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-asu-600" fill="currentColor" viewBox="0 0 24 24">
                        @if($action['icon'] === 'medical-cross')
                            <path d="M13 2h-2v9H2v2h9v9h2v-9h9v-2h-9V2z"/>
                        @elseif($action['icon'] === 'heart')
                            <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>
                        @elseif($action['icon'] === 'users')
                            <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zM4 18v-4.5c0-1.1.9-2 2-2h1.5c1.1 0 2 .9 2 2V18h2v-5.5c0-1.1.9-2 2-2h1.5c1.1 0 2 .9 2 2V18h2v-2h2v4H2v-2h2z"/>
                        @else
                            <path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z"/>
                        @endif
                    </svg>
                </div>
                
                <!-- Contenu -->
                <h3 class="text-lg font-bold text-gray-900 mb-3">{{ $action['title'] }}</h3>
                <p class="text-gray-600 text-sm">{{ $action['description'] }}</p>
                
                <div class="mt-4">
                    <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                        En savoir plus →
                    </a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Section Contact -->
<section id="contact" class="py-20 bg-gray-900 text-white">
    <div class="max-w-6xl mx-auto px-4">
        <!-- En-tête -->
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold mb-4">Contactez-nous</h2>
            <p class="text-lg text-gray-300 max-w-2xl mx-auto">
                Vous souhaitez nous rejoindre ou en savoir plus sur nos actions ?
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Informations de contact -->
            <div>
                <h3 class="text-xl font-bold mb-6">Nos coordonnées</h3>
                <div class="space-y-4">
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                        </svg>
                        <div>
                            <div class="font-medium">Adresse</div>
                            <div class="text-gray-300">{{ asu_config('contact.address') }}</div>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/>
                        </svg>
                        <div>
                            <div class="font-medium">Téléphone</div>
                            <div class="text-gray-300">{{ asu_config('contact.phone') }}</div>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                        </svg>
                        <div>
                            <div class="font-medium">Email</div>
                            <div class="text-gray-300">{{ asu_config('contact.email') }}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Réseaux sociaux -->
                <div class="mt-8">
                    <h4 class="font-medium mb-4">Suivez-nous</h4>
                    <div class="flex space-x-3">
                        @if(asu_config('social.facebook'))
                        <a href="{{ asu_config('social.facebook') }}" class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center hover:bg-blue-700 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        @endif
                        
                        @if(asu_config('social.youtube'))
                        <a href="{{ asu_config('social.youtube') }}" class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center hover:bg-red-700 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                            </svg>
                        </a>
                        @endif
                        
                        @if(asu_config('social.instagram'))
                        <a href="{{ asu_config('social.instagram') }}" class="w-10 h-10 bg-pink-600 rounded-lg flex items-center justify-center hover:bg-pink-700 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                        @endif
                    </div>
                </div>
            </div>
            
            <!-- Formulaire de contact -->
            <div class="bg-gray-800 p-6 rounded-lg">
                <h3 class="text-xl font-bold mb-6">Envoyez-nous un message</h3>
                <form class="space-y-4">
                    <div>
                        <label for="name" class="block text-sm font-medium mb-2">Nom complet</label>
                        <input type="text" id="name" name="name" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white">
                    </div>
                    
                    <div>
                        <label for="email" class="block text-sm font-medium mb-2">Email</label>
                        <input type="email" id="email" name="email" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white">
                    </div>
                    
                    <div>
                        <label for="subject" class="block text-sm font-medium mb-2">Sujet</label>
                        <input type="text" id="subject" name="subject" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white">
                    </div>
                    
                    <div>
                        <label for="message" class="block text-sm font-medium mb-2">Message</label>
                        <textarea id="message" name="message" rows="4" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white"></textarea>
                    </div>
                    
                    <button type="submit" class="w-full bg-asu-600 hover:bg-asu-700 text-white font-semibold py-3 px-6 rounded-lg transition-colors duration-300">
                        Envoyer le message
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-16 bg-asu-600 text-white text-center">
    <div class="max-w-4xl mx-auto px-4">
        <h2 class="text-2xl md:text-3xl font-bold mb-4">Rejoignez notre mission</h2>
        <p class="text-lg mb-8 text-asu-100">
            Ensemble, nous pouvons faire la différence dans la lutte contre le VIH/SIDA à Brazzaville.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="#" class="bg-white text-asu-600 hover:bg-gray-100 font-semibold px-6 py-3 rounded-lg transition-colors duration-300">
                Devenir bénévole
            </a>
            <a href="#" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 font-semibold px-6 py-3 rounded-lg transition-all duration-300">
                Faire un don
            </a>
        </div>
    </div>
</section>
@endsection