@extends('layouts.asu')@extends('layouts.asu')



@section('title', 'Accueil - Association Serment Universel')@section('title', 'Accueil - Association Serment Universel')



@section('head')@section('head')

<!-- AOS CSS --><!-- AOS CSS -->

<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet"><link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

@endsection@endsection



@section('content')@section('content')

<!-- Section Hero --><!-- Section Hero -->

<section class="relative min-h-screen bg-gradient-to-br from-asu-600 to-asu-800 text-white"><section class="relative min-h-screen bg-gradient-to-br from-asu-600 to-asu-800 text-white">

    <div class="absolute inset-0 bg-black/20"></div>    <div class="absolute inset-0 bg-black/20"></div>

        

    <div class="relative z-10 min-h-screen flex items-center">    <div class="relative z-10 min-h-screen flex items-center">

        <div class="max-w-6xl mx-auto px-4 text-center">        <div class="max-w-6xl mx-auto px-4 text-center">

            <!-- Logo/Icon -->            <!-- Logo/Icon -->

            <div class="mb-8" data-aos="zoom-in" data-aos-duration="1000">            <div class="mb-8" data-aos="zoom-in" data-aos-duration="1000">

                <div class="w-24 h-24 mx-auto bg-white/20 rounded-full flex items-center justify-center mb-6 animate-pulse">                <div class="w-24 h-24 mx-auto bg-white/20 rounded-full flex items-center justify-center mb-6 animate-pulse">

                    <svg class="w-12 h-12 text-white" fill="currentColor" viewBox="0 0 24 24">                    <svg class="w-12 h-12 text-white" fill="currentColor" viewBox="0 0 24 24">

                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>

                    </svg>                    </svg>

                </div>                </div>

            </div>            </div>

                        

            <!-- Titre principal -->            <!-- Titre principal -->

            <h1 class="text-4xl md:text-6xl font-bold mb-6" data-aos="fade-up" data-aos-delay="200">            <h1 class="text-4xl md:text-6xl font-bold mb-6" data-aos="fade-up" data-aos-delay="200">

                Association <span class="text-yellow-300">Serment Universel</span>                Association <span class="text-yellow-300">Serment Universel</span>

            </h1>            </h1>

                        

            <!-- Sous-titre -->            <!-- Sous-titre -->

            <p class="text-xl md:text-2xl mb-8 text-white/90 max-w-4xl mx-auto" data-aos="fade-up" data-aos-delay="400">            <p class="text-xl md:text-2xl mb-8 text-white/90 max-w-4xl mx-auto" data-aos="fade-up" data-aos-delay="400">

                {{ $settings['site_description'] ?? 'Depuis 27 ans, nous œuvrons pour la prévention du VIH/SIDA et l\'accompagnement psychosocial en République du Congo' }}                {{ $settings['site_description'] ?? 'Depuis 27 ans, nous œuvrons pour la prévention du VIH/SIDA et l\'accompagnement psychosocial en République du Congo' }}

            </p>            </p>

                        

            <!-- Boutons d'action -->            <!-- Boutons d'action -->

            <div class="flex flex-col sm:flex-row gap-4 justify-center mb-12" data-aos="fade-up" data-aos-delay="600">            <div class="flex flex-col sm:flex-row gap-4 justify-center mb-12" data-aos="fade-up" data-aos-delay="600">

                <a href="#nos-actions" class="bg-white text-asu-600 hover:bg-gray-100 hover:scale-105 font-semibold px-8 py-4 rounded-lg transition-all duration-300 transform">                <a href="#nos-actions" class="bg-white text-asu-600 hover:bg-gray-100 hover:scale-105 font-semibold px-8 py-4 rounded-lg transition-all duration-300 transform">

                    Découvrir nos actions                    Découvrir nos actions

                </a>                </a>

                <a href="#" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 hover:scale-105 font-semibold px-8 py-4 rounded-lg transition-all duration-300 transform">                <a href="{{ route('about') }}" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 hover:scale-105 font-semibold px-8 py-4 rounded-lg transition-all duration-300 transform">

                    En savoir plus                    En savoir plus

                </a>                </a>

            </div>            </div>

                        

            <!-- Statistiques -->            <!-- Statistiques rapides -->

            <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mt-16" data-aos="fade-up" data-aos-delay="800">            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-3xl mx-auto text-center" data-aos="fade-up" data-aos-delay="800">

                <div class="text-center">                <div data-aos="zoom-in" data-aos-delay="900">

                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['years_active'] ?? 27 }}">0</div>                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['years_active'] }}">0</div>

                    <div class="text-sm uppercase tracking-wide">Années d'expérience</div>                    <div class="text-sm text-white/80">Années</div>

                </div>                </div>

                <div class="text-center">                <div data-aos="zoom-in" data-aos-delay="1000">

                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['articles_count'] ?? 50 }}">0</div>                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['articles_count'] }}">0</div>

                    <div class="text-sm uppercase tracking-wide">Articles publiés</div>                    <div class="text-sm text-white/80">Articles</div>

                </div>                </div>

                <div class="text-center">                <div data-aos="zoom-in" data-aos-delay="1100">

                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['projects_count'] ?? 15 }}">0</div>                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['projects_count'] }}">0</div>

                    <div class="text-sm uppercase tracking-wide">Projets réalisés</div>                    <div class="text-sm text-white/80">Projets</div>

                </div>                </div>

                <div class="text-center">                <div data-aos="zoom-in" data-aos-delay="1200">

                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['partners_count'] ?? 8 }}">0</div>                    <div class="text-2xl font-bold text-yellow-300 counter" data-target="{{ $stats['partners_count'] }}">0</div>

                    <div class="text-sm uppercase tracking-wide">Partenaires</div>                    <div class="text-sm text-white/80">Partenaires</div>

                </div>                </div>

            </div>            </div>

        </div>        </div>

    </div>    </div>

</section>    

    <!-- Indicateur de scroll -->

<!-- Section À Propos -->    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce" data-aos="fade-up" data-aos-delay="1400">

<section id="a-propos" class="py-20 bg-gray-50">        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">

    <div class="max-w-6xl mx-auto px-4">            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>

        <div class="text-center mb-16" data-aos="fade-up">        </svg>

            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">À Propos de l'ASU</h2>    </div>

            <p class="text-xl text-gray-600 max-w-3xl mx-auto"></section>

                Fondée en 1998, l'Association Serment Universel (ASU) a pour mission de placer l'humain au cœur de l'action solidaire.

            </p><!-- ============================================================================ -->

        </div><!-- BLOC 2: SECTION À PROPOS                                                   -->

        <!-- Début: ligne 71 - Fin: ligne 125                                           -->

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center"><!-- Contenu: Description ASU, mission, valeurs, image équipe                   -->

            <div data-aos="fade-right"><!-- Données: asu_config() helpers (dynamique)                                  -->

                <h3 class="text-2xl font-bold text-gray-900 mb-6">Notre Mission</h3><!-- ============================================================================ -->

                <p class="text-gray-600 mb-6"><!-- Section À propos -->

                    L'ASU œuvre dans la prévention du VIH/SIDA, l'accompagnement psychosocial des personnes affectées et infectées, ainsi que dans le développement communautaire en République du Congo.<section id="a-propos" class="py-20 bg-white">

                </p>    <div class="max-w-6xl mx-auto px-4">

                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">

                <h4 class="text-xl font-semibold text-gray-900 mb-4">Nos Valeurs</h4>            <!-- Texte -->

                <ul class="space-y-3 text-gray-600">            <div data-aos="fade-right">

                    <li class="flex items-start">                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">À propos de l'ASU</h2>

                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">                

                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                <div class="space-y-4 text-gray-700 leading-relaxed">

                        </svg>                    <p class="text-lg">

                        <span><strong>Solidarité :</strong> Soutien mutuel et entraide communautaire</span>                        Créée en <strong>1998</strong>, l'Association Serment Universel (ASU) 

                    </li>                        est une organisation non gouvernementale congolaise dédiée à la lutte contre le VIH/SIDA 

                    <li class="flex items-start">                        et à l'accompagnement psychosocial des personnes affectées à Brazzaville.

                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">                    </p>

                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                    <p>

                        </svg>                        Notre mission est de <strong>placer l'humain au cœur de l'action solidaire</strong>, 

                        <span><strong>Respect :</strong> Dignité et acceptation de chaque personne</span>                        en mettant l'accent sur la prévention, l'éducation et le soutien communautaire.

                    </li>                    </p>

                    <li class="flex items-start">                    <p>

                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">                        Nous croyons fermement que chaque personne mérite d'être accompagnée avec dignité 

                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                        et respect, sans discrimination aucune.

                        </svg>                    </p>

                        <span><strong>Engagement :</strong> Dévouement total à notre cause</span>                </div>

                    </li>                

                    <li class="flex items-start">                <!-- Valeurs -->

                        <svg class="w-5 h-5 text-asu-600 mt-1 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">                <div class="mt-8">

                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>                    <h3 class="text-xl font-bold text-gray-900 mb-4">Nos valeurs</h3>

                        </svg>                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">

                        <span><strong>Innovation :</strong> Approches créatives pour le changement</span>                        <div class="flex items-center space-x-2">

                    </li>                            <div class="w-2 h-2 bg-asu-600 rounded-full"></div>

                </ul>                            <span class="text-gray-700">Dignité pour tous</span>

            </div>                        </div>

                                    <div class="flex items-center space-x-2">

            <div data-aos="fade-left">                            <div class="w-2 h-2 bg-asu-600 rounded-full"></div>

                <div class="relative">                            <span class="text-gray-700">Force du collectif</span>

                    <img src="{{ asset('images/about-image.jpg') }}" alt="À propos de l'ASU" class="rounded-lg shadow-xl">                        </div>

                    <div class="absolute inset-0 bg-asu-600/20 rounded-lg"></div>                        <div class="flex items-center space-x-2">

                </div>                            <div class="w-2 h-2 bg-asu-600 rounded-full"></div>

            </div>                            <span class="text-gray-700">Espoir et solidarité</span>

        </div>                        </div>

    </div>                        <div class="flex items-center space-x-2">

</section>                            <div class="w-2 h-2 bg-asu-600 rounded-full"></div>

                            <span class="text-gray-700">Accompagnement psychosocial</span>

<!-- Section Nos Actions -->                        </div>

<section id="nos-actions" class="py-20 bg-white">                    </div>

    <div class="max-w-6xl mx-auto px-4">                </div>

        <div class="text-center mb-16" data-aos="fade-up">            </div>

            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Actions</h2>            

            <p class="text-xl text-gray-600 max-w-3xl mx-auto">            <!-- Image -->

                Découvrez nos différents domaines d'intervention pour un impact durable dans nos communautés.            <div class="relative" data-aos="fade-left">

            </p>                <img src="https://images.unsplash.com/photo-1559027615-cd4628902d4a?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 

        </div>                     alt="Équipe ASU Brazzaville" 

                             class="rounded-lg shadow-lg w-full hover:scale-105 transition-transform duration-300">

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">                <div class="absolute inset-0 bg-asu-600/20 rounded-lg"></div>

            <!-- Action 1: Prévention VIH/SIDA -->            </div>

            <div class="bg-gradient-to-br from-red-50 to-red-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="100">        </div>

                <div class="w-12 h-12 bg-red-600 rounded-lg flex items-center justify-center mb-4">    </div>

                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"></section>

                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>

                    </svg><!-- ============================================================================ -->

                </div><!-- BLOC 3: SECTION NOS ACTIONS                                                -->

                <h3 class="text-xl font-bold text-gray-900 mb-3">Prévention VIH/SIDA</h3><!-- Début: ligne 139 - Fin: ligne 190                                          -->

                <p class="text-gray-600 text-sm mb-3">Sensibilisation, dépistage et accompagnement des personnes affectées par le VIH/SIDA.</p><!-- Contenu: Grille des 4 domaines d'action (prévention, accompagnement, etc.) -->

                <a href="#" class="text-red-600 hover:text-red-700 font-medium text-sm">En savoir plus →</a><!-- Données: asu_config('actions') (dynamique)                                 -->

            </div><!-- ============================================================================ -->

            <!-- Section Nos Actions -->

            <!-- Action 2: Accompagnement Psychosocial --><section id="nos-actions" class="py-20 bg-gray-50">

            <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="200">    <div class="max-w-6xl mx-auto px-4">

                <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mb-4">        <!-- En-tête de section -->

                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">        <div class="text-center mb-16" data-aos="fade-up">

                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Actions</h2>

                    </svg>            <p class="text-lg text-gray-600 max-w-2xl mx-auto">

                </div>                Découvrez les domaines dans lesquels nous intervenons pour soutenir les communautés de Brazzaville

                <h3 class="text-xl font-bold text-gray-900 mb-3">Accompagnement Psychosocial</h3>            </p>

                <p class="text-gray-600 text-sm mb-3">Soutien émotionnel et social pour les personnes vulnérables et leurs familles.</p>        </div>

                <a href="#" class="text-blue-600 hover:text-blue-700 font-medium text-sm">En savoir plus →</a>        

            </div>        <!-- Grille des actions -->

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">

            <!-- Action 3: Développement Communautaire -->            <!-- Action 1: Prévention VIH/SIDA -->

            <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="300">            <div class="bg-white rounded-lg shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300 p-6 text-center group" data-aos="fade-up" data-aos-delay="100">

                <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mb-4">                <div class="w-16 h-16 bg-asu-100 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-asu-200 transition-colors duration-300">

                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">                    <svg class="w-8 h-8 text-asu-600 group-hover:scale-110 transition-transform duration-300" fill="currentColor" viewBox="0 0 24 24">

                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>                        <path d="M13 2h-2v9H2v2h9v9h2v-9h9v-2h-9V2z"/>

                    </svg>                    </svg>

                </div>                </div>

                <h3 class="text-xl font-bold text-gray-900 mb-3">Développement Communautaire</h3>                <h3 class="text-lg font-bold text-gray-900 mb-3">Prévention VIH/SIDA</h3>

                <p class="text-gray-600 text-sm mb-3">Projets de développement durable pour améliorer les conditions de vie.</p>                <p class="text-gray-600 text-sm">Sensibilisation et prévention auprès des communautés</p>

                <a href="#" class="text-green-600 hover:text-green-700 font-medium text-sm">En savoir plus →</a>                <div class="mt-4">

            </div>                    <a href="{{ route('about') }}" class="text-asu-600 hover:text-asu-700 font-medium text-sm">

                                    En savoir plus →

            <!-- Action 4: Formation et Éducation -->                    </a>

            <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-lg p-6 hover:shadow-lg transition-all duration-300" data-aos="fade-up" data-aos-delay="400">                </div>

                <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mb-4">            </div>

                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>            <!-- Action 2: Accompagnement psychosocial -->

                    </svg>            <div class="bg-white rounded-lg shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300 p-6 text-center group" data-aos="fade-up" data-aos-delay="200">

                </div>                <div class="w-16 h-16 bg-asu-100 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-asu-200 transition-colors duration-300">

                <h3 class="text-xl font-bold text-gray-900 mb-3">Formation et Éducation</h3>                    <svg class="w-8 h-8 text-asu-600 group-hover:scale-110 transition-transform duration-300" fill="currentColor" viewBox="0 0 24 24">

                <p class="text-gray-600 text-sm mb-3">Programmes de formation et sensibilisation pour tous les âges.</p>                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>

                <a href="#" class="text-purple-600 hover:text-purple-700 font-medium text-sm">En savoir plus →</a>                    </svg>

            </div>                </div>

        </div>                <h3 class="text-lg font-bold text-gray-900 mb-3">Accompagnement psychosocial</h3>

    </div>                <p class="text-gray-600 text-sm">Soutien psychologique aux personnes vulnérables</p>

</section>                <div class="mt-4">

                    <a href="{{ route('about') }}" class="text-asu-600 hover:text-asu-700 font-medium text-sm">

<!-- Section Actualités -->                        En savoir plus →

<section id="actualites" class="py-20 bg-gray-50">                    </a>

    <div class="max-w-6xl mx-auto px-4">                </div>

        <div class="text-center mb-16" data-aos="fade-up">            </div>

            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Actualités</h2>

            <p class="text-xl text-gray-600 max-w-3xl mx-auto">            <!-- Action 3: Soutien communautaire -->

                Restez informés de nos dernières actions et actualités.            <div class="bg-white rounded-lg shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300 p-6 text-center group" data-aos="fade-up" data-aos-delay="300">

            </p>                <div class="w-16 h-16 bg-asu-100 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-asu-200 transition-colors duration-300">

        </div>                    <svg class="w-8 h-8 text-asu-600 group-hover:scale-110 transition-transform duration-300" fill="currentColor" viewBox="0 0 24 24">

                                <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zM4 18v-4.5c0-1.1.9-2 2-2h1.5c1.1 0 2 .9 2 2V18h2v-5.5c0-1.1.9-2 2-2h1.5c1.1 0 2 .9 2 2V18h2v-2h2v4H2v-2h2z"/>

        <!-- Grille des actualités -->                    </svg>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">                </div>

            @forelse($latestArticles->take(3) as $article)                <h3 class="text-lg font-bold text-gray-900 mb-3">Soutien communautaire</h3>

                <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">                <p class="text-gray-600 text-sm">Renforcement des liens communautaires</p>

                    @if($article->featured_image)                <div class="mt-4">

                        <img src="{{ asset('storage/' . $article->featured_image) }}"                     <a href="{{ route('about') }}" class="text-asu-600 hover:text-asu-700 font-medium text-sm">

                             alt="{{ $article->title }}"                        En savoir plus →

                             class="w-full h-48 object-cover">                    </a>

                    @else                </div>

                        <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center">            </div>

                            <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>            <!-- Action 4: Éducation à la santé -->

                            </svg>            <div class="bg-white rounded-lg shadow-lg hover:shadow-xl hover:scale-105 transition-all duration-300 p-6 text-center group" data-aos="fade-up" data-aos-delay="400">

                        </div>                <div class="w-16 h-16 bg-asu-100 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-asu-200 transition-colors duration-300">

                    @endif                    <svg class="w-8 h-8 text-asu-600 group-hover:scale-110 transition-transform duration-300" fill="currentColor" viewBox="0 0 24 24">

                                            <path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z"/>

                    <div class="p-6">                    </svg>

                        <div class="text-sm text-asu-600 font-medium mb-2">{{ $article->created_at->format('d M Y') }}</div>                </div>

                        <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $article->title }}</h3>                <h3 class="text-lg font-bold text-gray-900 mb-3">Éducation à la santé</h3>

                        <p class="text-gray-600 mb-4 line-clamp-3">                <p class="text-gray-600 text-sm">Formation et sensibilisation en santé publique</p>

                            {{ $article->excerpt ?? Str::limit(strip_tags($article->content), 120) }}                <div class="mt-4">

                        </p>                    <a href="{{ route('about') }}" class="text-asu-600 hover:text-asu-700 font-medium text-sm">

                        <a href="{{ route('article', $article->slug) }}" class="text-asu-600 hover:text-asu-700 font-medium">Lire la suite →</a>                        En savoir plus →

                    </div>                    </a>

                </article>                </div>

            @empty            </div>

                <div class="col-span-full text-center py-12">        </div>

                    <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">    </div>

                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path></section>

                    </svg>

                    <p class="text-gray-500">Aucun article disponible pour le moment.</p><!-- ============================================================================ -->

                </div><!-- BLOC 4: SECTION ACTUALITÉS                                                 -->

            @endforelse<!-- Début: ligne 196 - Fin: ligne 245                                          -->

        </div><!-- Contenu: Grille des 3 derniers articles/actualités                         -->

        <!-- Données: $latestArticles (dynamique depuis base de données)               -->

        <div class="text-center mt-12" data-aos="fade-up"><!-- ============================================================================ -->

            <a href="{{ route('actualites') }}" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300"><!-- Section Actualités -->

                Voir toutes les actualités<section id="actualites" class="py-20 bg-white">

            </a>    <div class="max-w-6xl mx-auto px-4">

        </div>        <!-- En-tête de section -->

    </div>        <div class="text-center mb-16" data-aos="fade-up">

</section>            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Actualités</h2>

            <p class="text-lg text-gray-600 max-w-2xl mx-auto">

<!-- Section Contact -->                Suivez nos dernières actions et initiatives en République du Congo

<section id="contact" class="py-20 bg-asu-600 text-white">            </p>

    <div class="max-w-6xl mx-auto px-4">        </div>

        <div class="text-center mb-16" data-aos="fade-up">        

            <h2 class="text-3xl md:text-4xl font-bold mb-4">Contactez-nous</h2>        <!-- Grille des actualités -->

            <p class="text-xl text-white/90 max-w-3xl mx-auto">        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">

                N'hésitez pas à nous contacter pour toute question ou pour rejoindre nos actions.            @forelse($latestArticles->take(3) as $article)

            </p>                <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">

        </div>                    @if($article->featured_image)

                                <img src="{{ asset('storage/' . $article->featured_image) }}" 

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">                             alt="{{ $article->title }}"

            <!-- Informations de contact -->                             class="w-full h-48 object-cover">

            <div data-aos="fade-right">                    @else

                <h3 class="text-2xl font-bold mb-8">Nos Coordonnées</h3>                        <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center">

                                            <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">

                <div class="space-y-6">                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z" />

                    <div class="flex items-start space-x-3">                            </svg>

                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">                        </div>

                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>                    @endif

                        </svg>                    <div class="p-6">

                        <div>                        <div class="text-sm text-asu-600 font-medium mb-2">{{ $article->created_at->format('d M Y') }}</div>

                            <div class="font-medium">Adresse</div>                        <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $article->title }}</h3>

                            <div class="text-gray-300">123 Avenue de la Paix, Brazzaville, République du Congo</div>                        <p class="text-gray-600 mb-4">

                        </div>                            {{ $article->excerpt ?: Str::limit(strip_tags($article->content), 120) }}

                    </div>                        </p>

                                            <a href="{{ route('article', $article->slug) }}" class="text-asu-600 hover:text-asu-700 font-medium">Lire la suite →</a>

                    <div class="flex items-start space-x-3">                    </div>

                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">                </article>

                            <path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/>            @empty

                        </svg>                <div class="col-span-3 text-center py-12">

                        <div>                    <p class="text-gray-500">Aucun article disponible pour le moment.</p>

                            <div class="font-medium">Téléphone</div>                </div>

                            <div class="text-gray-300">+242 05 123 45 67</div>            @endforelse

                        </div>        </div>

                    </div>        

                            <!-- Bouton voir plus -->

                    <div class="flex items-start space-x-3">        <div class="text-center mt-12" data-aos="fade-up" data-aos-delay="400">

                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">            <a href="{{ route('actualites') }}" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">

                            <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>                Voir toutes les actualités

                        </svg>            </a>

                        <div>        </div>

                            <div class="font-medium">Email</div>    </div>

                            <div class="text-gray-300">contact@asu-congo.org</div></section>

                        </div>

                    </div><!-- ============================================================================ -->

                </div><!-- BLOC 5: SECTION TÉMOIGNAGES                                                -->

                <!-- Début: ligne 253 - Fin: ligne 305                                          -->

                <!-- Réseaux sociaux --><!-- Contenu: Carrousel de témoignages de bénéficiaires et bénévoles           -->

                <div class="mt-8"><!-- Données: $featuredTestimonials (dynamique depuis base de données)         -->

                    <h4 class="font-medium mb-4">Suivez-nous</h4><!-- ============================================================================ -->

                    <div class="flex space-x-3"><!-- Section Témoignages -->

                        <a href="https://facebook.com/asu.congo" class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center hover:bg-blue-700 transition-colors"><section id="temoignages" class="py-20 bg-gray-50">

                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">    <div class="max-w-6xl mx-auto px-4">

                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>        <!-- En-tête de section -->

                            </svg>        <div class="text-center mb-16" data-aos="fade-up">

                        </a>            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Témoignages</h2>

                        <a href="https://youtube.com/c/asucongo" class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center hover:bg-red-700 transition-colors">            <p class="text-lg text-gray-600 max-w-2xl mx-auto">

                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">                Les histoires de ceux qui ont bénéficié de notre accompagnement

                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>            </p>

                            </svg>        </div>

                        </a>        

                        <a href="https://instagram.com/asu_congo" class="w-10 h-10 bg-pink-600 rounded-lg flex items-center justify-center hover:bg-pink-700 transition-colors">        <!-- Grille des témoignages -->

                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">

                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>            @forelse($featuredTestimonials as $testimonial)

                            </svg>                <div class="bg-white rounded-lg shadow-lg p-6 relative" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">

                        </a>                    <div class="absolute top-4 left-4 text-asu-200">

                    </div>                        <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 24 24">

                </div>                            <path d="M14,17H17L19,13V7H13V13H16M6,17H9L11,13V7H5V13H8L6,17Z" />

            </div>                        </svg>

                                </div>

            <!-- Formulaire de contact -->                    <div class="pt-6">

            <div data-aos="fade-left">                        <p class="text-gray-600 mb-4 italic">

                <form class="space-y-6" action="#" method="POST">                            "{{ $testimonial->content }}"

                    @csrf                        </p>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">                        <div class="flex items-center">

                        <div>                            @if($testimonial->avatar)

                            <label for="name" class="block text-sm font-medium mb-2">Nom complet</label>                                <img src="{{ asset('storage/' . $testimonial->avatar) }}" 

                            <input type="text" id="name" name="name" required                                     alt="{{ $testimonial->name }}"

                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50">                                     class="w-12 h-12 rounded-full mr-4 object-cover">

                        </div>                            @else

                        <div>                                <div class="w-12 h-12 bg-asu-100 rounded-full flex items-center justify-center mr-4">

                            <label for="email" class="block text-sm font-medium mb-2">Email</label>                                    <span class="text-asu-600 font-bold text-lg">{{ substr($testimonial->name, 0, 1) }}</span>

                            <input type="email" id="email" name="email" required                                </div>

                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50">                            @endif

                        </div>                            <div>

                    </div>                                <div class="font-semibold text-gray-900">{{ $testimonial->name }}</div>

                                                    @if($testimonial->title)

                    <div>                                    <div class="text-sm text-gray-500">{{ $testimonial->title }}</div>

                        <label for="subject" class="block text-sm font-medium mb-2">Sujet</label>                                @endif

                        <input type="text" id="subject" name="subject" required                            </div>

                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50">                        </div>

                    </div>                    </div>

                                    </div>

                    <div>            @empty

                        <label for="message" class="block text-sm font-medium mb-2">Message</label>                <div class="col-span-3 text-center py-12">

                        <textarea id="message" name="message" rows="5" required                    <p class="text-gray-500">Aucun témoignage disponible pour le moment.</p>

                                  class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/70 focus:outline-none focus:ring-2 focus:ring-white/50 resize-none"></textarea>                </div>

                    </div>            @endforelse

                            </div>

                    <button type="submit"     </div>

                            class="w-full bg-white text-asu-600 hover:bg-gray-100 font-semibold px-8 py-3 rounded-lg transition-colors duration-300"></section>

                        Envoyer le message

                    </button><!-- ============================================================================ -->

                </form><!-- BLOC 6: SECTION GALERIE                                                    -->

            </div><!-- Debut: ligne 311 - Fin: ligne 455                                          -->

        </div><!-- Contenu: Grille d'images de nos activites et evenements                   -->

    </div><!-- Donnees: $galleryImages (dynamique) + images fallback Unsplash (@empty)   -->

</section><!-- ============================================================================ -->

@endsection<!-- Section Galerie -->

<section id="galerie" class="py-20 bg-white">

@section('scripts')    <div class="max-w-6xl mx-auto px-4">

<!-- AOS JavaScript -->        <!-- En-tête de section -->

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>        <div class="text-center mb-16" data-aos="fade-up">

            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Galerie</h2>

<script>            <p class="text-lg text-gray-600 max-w-2xl mx-auto">

    // Initialisation AOS                Découvrez nos actions en images

    AOS.init({            </p>

        duration: 1000,        </div>

        once: true,        

        offset: 100        <!-- Grille de la galerie -->

    });        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">

                @forelse($galleryImages as $image)

    // Animation des compteurs                <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" 

    function animateCounters() {                     data-aos="zoom-in" 

        const counters = document.querySelectorAll('.counter');                     data-aos-delay="{{ $loop->iteration * 100 }}">

                            <img src="{{ Storage::url($image->image_path) }}" 

        counters.forEach(counter => {                         alt="{{ $image->title }}" 

            const target = parseInt(counter.getAttribute('data-target'));                         class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">

            const duration = 2000;                    <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">

            const increment = target / (duration / 16);                        <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">

            let current = 0;                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 616 0z"></path>

                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>

            const timer = setInterval(() => {                        </svg>

                current += increment;                    </div>

                if (current >= target) {                    @if($image->description)

                    current = target;                        <div class="absolute bottom-0 left-0 right-0 bg-black/70 text-white p-2 text-sm">

                    clearInterval(timer);                            {{ $image->description }}

                }                        </div>

                counter.textContent = Math.floor(current);                    @endif

            }, 16);                </div>

        });            @empty

    }                <!-- Images par défaut si pas d'images en base -->

                <!-- Image 1 -->

    // Déclencher l'animation des compteurs quand la section est visible            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="100">

    const observer = new IntersectionObserver((entries) => {                <img src="https://images.unsplash.com/photo-1559027615-cd4628902d4a?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 

        entries.forEach(entry => {                     alt="Formation communautaire" 

            if (entry.isIntersecting) {                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">

                animateCounters();                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">

                observer.unobserve(entry.target);                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">

            }                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>

        });                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>

    });                    </svg>

                    </div>

    const statsSection = document.querySelector('.counter').closest('section');            </div>

    if (statsSection) {            

        observer.observe(statsSection);            <!-- Image 2 -->

    }            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="200">

                    <img src="https://images.unsplash.com/photo-1584432810601-6c7f27d2362b?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 

    // Smooth scroll pour les liens d'ancrage                     alt="Sensibilisation école" 

    document.querySelectorAll('a[href^="#"]').forEach(anchor => {                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">

        anchor.addEventListener('click', function (e) {                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">

            e.preventDefault();                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">

            const target = document.querySelector(this.getAttribute('href'));                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>

            if (target) {                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>

                target.scrollIntoView({                    </svg>

                    behavior: 'smooth',                </div>

                    block: 'start'            </div>

                });            

            }            <!-- Image 3 -->

        });            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="300">

    });                <img src="https://images.unsplash.com/photo-1576091160550-2173dba999ef?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 

</script>                     alt="Événement communautaire" 

@endsection                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </div>
            
            <!-- Image 4 -->
            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="400">
                <img src="https://images.unsplash.com/photo-1582213782179-e0d53f98f2ca?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 
                     alt="Formation bénévoles" 
                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </div>
            
            <!-- Images 5-8 -->
            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="500">
                <img src="https://images.unsplash.com/photo-1593113646773-028c64a8f1b8?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 
                     alt="Accompagnement médical" 
                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </div>
            
            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="600">
                <img src="https://images.unsplash.com/photo-1576267423445-b2e0074d68a4?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 
                     alt="Réunion équipe" 
                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </div>
            
            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="700">
                <img src="https://images.unsplash.com/photo-1559757148-5c350d0d3c56?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 
                     alt="Consultation médicale" 
                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </div>
            
            <div class="relative overflow-hidden rounded-lg aspect-square group cursor-pointer" data-aos="zoom-in" data-aos-delay="800">
                <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80" 
                     alt="Distribution matériel" 
                     class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/40 transition-colors duration-300 flex items-center justify-center">
                    <svg class="w-8 h-8 text-white opacity-0 group-hover:opacity-100 transition-opacity duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </div>
        </div>
        
        <!-- Bouton voir plus -->
        <div class="text-center mt-12" data-aos="fade-up" data-aos-delay="900">
            <a href="{{ route('gallery') }}" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                Voir toute la galerie
            </a>
        </div>
    @endforelse
    </div>
</section>

<!-- ============================================================================ -->
<!-- BLOC 7: SECTION FAQ (QUESTIONS FRÉQUENTES)                                -->
<!-- Début: ligne 461 - Fin: ligne 490                                          -->
<!-- Contenu: Accordéon de questions-réponses les plus fréquentes              -->
<!-- Données: $featuredFaqs (dynamique depuis base de données)                 -->
<!-- ============================================================================ -->
<!-- Section FAQ -->
<section id="faq" class="py-20 bg-gray-50">
    <div class="max-w-4xl mx-auto px-4">
        <!-- En-tête de section -->
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Questions Fréquentes</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Trouvez des réponses aux questions les plus courantes sur nos services
            </p>
        </div>
        
        <!-- Liste des FAQ -->
        <div class="space-y-6">
            @forelse($featuredFaqs as $faq)
                <div class="bg-white rounded-lg shadow-md" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">
                    <button class="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-50 focus:outline-none focus:bg-gray-50" onclick="toggleFaq({{ $faq->id }})">
                        <span class="font-semibold text-gray-900">{{ $faq->question }}</span>
                        <svg class="w-5 h-5 text-gray-500 transform transition-transform duration-200" id="faq-icon-{{ $faq->id }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="px-6 pb-4 hidden" id="faq-content-{{ $faq->id }}">
                        <div class="text-gray-600">
                            {!! nl2br(e($faq->answer)) !!}
                        </div>
                    </div>
                </div>
            @empty
                <div class="text-center py-12">
                    <p class="text-gray-500 text-lg">Aucune FAQ disponible pour le moment.</p>
                </div>
            @endforelse
            </div>
        </div>
    </div>
</section>

<!-- ============================================================================ -->
<!-- BLOC 8: SECTION PROJETS                                                    -->
<!-- Début: ligne 496 - Fin: ligne 594                                          -->
<!-- Contenu: Grille des projets actifs avec statut, budget et progression     -->
<!-- Données: $activeProjects (dynamique depuis base de données)               -->
<!-- ============================================================================ -->
<!-- Section Projets -->
<section id="projets" class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <!-- En-tête de section -->
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Projets</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Découvrez nos initiatives en cours et nos projets futurs pour lutter contre le VIH/SIDA
            </p>
        </div>
        
        <!-- Grille des projets -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($activeProjects as $project)
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">
                    <div class="relative">
                        @if($project->featured_image)
                            <img src="{{ Storage::url($project->featured_image) }}" 
                                 alt="{{ $project->title }}" 
                                 class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                        @else
                            <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                                <svg class="w-16 h-16 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                        @endif
                        <div class="absolute top-4 right-4 text-white px-3 py-1 rounded-full text-sm font-medium
                            @if($project->status === 'active') bg-green-500
                            @elseif($project->status === 'planned') bg-blue-500
                            @elseif($project->status === 'completed') bg-orange-500
                            @else bg-gray-500
                            @endif">
                            @if($project->status === 'active') En cours
                            @elseif($project->status === 'planned') Planifié
                            @elseif($project->status === 'completed') Terminé
                            @else {{ ucfirst($project->status) }}
                            @endif
                        </div>
                    </div>
                    <div class="p-6">
                        <div class="flex items-center mb-2">
                            <div class="w-2 h-2 rounded-full mr-2
                                @if($project->status === 'active') bg-green-500
                                @elseif($project->status === 'planned') bg-blue-500
                                @elseif($project->status === 'completed') bg-orange-500
                                @else bg-gray-500
                                @endif"></div>
                            <span class="text-sm font-medium
                                @if($project->status === 'active') text-green-600
                                @elseif($project->status === 'planned') text-blue-600
                                @elseif($project->status === 'completed') text-orange-600
                                @else text-gray-600
                                @endif">
                                @if($project->start_date && $project->end_date)
                                    {{ $project->start_date->format('Y') }}-{{ $project->end_date->format('Y') }}
                                @elseif($project->start_date)
                                    Depuis {{ $project->start_date->format('Y') }}
                                @endif
                            </span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $project->title }}</h3>
                        <p class="text-gray-600 mb-4">
                            {{ Str::limit($project->description, 120) }}
                        </p>
                        <div class="flex items-center justify-between">
                            @if($project->budget)
                                <div class="text-sm text-gray-500">
                                    <span class="font-medium">Budget:</span> {{ number_format($project->budget, 0, ',', ' ') }}€
                                </div>
                            @elseif($project->beneficiaries)
                                <div class="text-sm text-gray-500">
                                    <span class="font-medium">Bénéficiaires:</span> {{ number_format($project->beneficiaries) }}
                                </div>
                            @else
                                <div></div>
                            @endif
                            <a href="{{ route('project', $project->slug) }}" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                                En savoir plus →
                            </a>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-12">
                    <svg class="w-16 h-16 text-gray-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <p class="text-gray-500 text-lg">Aucun projet disponible pour le moment.</p>
                </div>
            @endforelse
        </div>
        
        <!-- Bouton voir plus -->
        <div class="text-center mt-12" data-aos="fade-up" data-aos-delay="400">
            <a href="{{ route('projets') }}" class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                Voir tous les projets
            </a>
        </div>
    </div>
</section>

<!-- ============================================================================ -->
<!-- BLOC 9: SECTION DOCUMENTS & RESSOURCES                                    -->
<!-- Début: ligne 600 - Fin: ligne 751                                          -->
<!-- Contenu: Grille de documents téléchargeables + statistiques downloads     -->
<!-- Données: $featuredDocuments (dynamique) + documents fallback (@empty)     -->
<!-- ============================================================================ -->
<!-- Section Documents -->
<section id="documents" class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <!-- En-tête de section -->
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Documents & Ressources</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Accédez à nos rapports, guides et documents utiles pour la prévention
            </p>
        </div>
        
        <!-- Grille des documents -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            @forelse($featuredDocuments as $document)
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 p-6 group" data-aos="fade-up" data-aos-delay="{{ $loop->iteration * 100 }}">
                    @php
                        $colors = [
                            'pdf' => ['bg' => 'bg-red-100', 'hover' => 'group-hover:bg-red-200', 'text' => 'text-red-600', 'button' => 'bg-red-600 hover:bg-red-700'],
                            'doc' => ['bg' => 'bg-blue-100', 'hover' => 'group-hover:bg-blue-200', 'text' => 'text-blue-600', 'button' => 'bg-blue-600 hover:bg-blue-700'],
                            'docx' => ['bg' => 'bg-blue-100', 'hover' => 'group-hover:bg-blue-200', 'text' => 'text-blue-600', 'button' => 'bg-blue-600 hover:bg-blue-700'],
                            'zip' => ['bg' => 'bg-green-100', 'hover' => 'group-hover:bg-green-200', 'text' => 'text-green-600', 'button' => 'bg-green-600 hover:bg-green-700'],
                            'default' => ['bg' => 'bg-purple-100', 'hover' => 'group-hover:bg-purple-200', 'text' => 'text-purple-600', 'button' => 'bg-purple-600 hover:bg-purple-700']
                        ];
                        $fileExtension = strtolower(pathinfo($document->file_name, PATHINFO_EXTENSION));
                        $color = $colors[$fileExtension] ?? $colors['default'];
                    @endphp
                    
                    <div class="flex items-center justify-center w-16 h-16 {{ $color['bg'] }} rounded-lg mb-4 mx-auto {{ $color['hover'] }} transition-colors duration-300">
                        <svg class="w-8 h-8 {{ $color['text'] }}" fill="currentColor" viewBox="0 0 24 24">
                            @if($fileExtension === 'pdf')
                                <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z" />
                            @elseif(in_array($fileExtension, ['doc', 'docx']))
                                <path d="M9,4V6H21V4H9M9,14H21V12H9V14M9,10H21V8H9V10M9,20H21V18H9V20M5,4V6H7V4H5M5,14H7V12H5V14M5,10H7V8H5V10M5,20H7V18H5V20M3,4A1,1 0 0,0 2,5V19A1,1 0 0,0 3,20H8A1,1 0 0,0 9,19V5A1,1 0 0,0 8,4H3Z" />
                            @elseif($fileExtension === 'zip')
                                <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20M12,11A3,3 0 0,1 15,14A3,3 0 0,1 12,17A3,3 0 0,1 9,14A3,3 0 0,1 12,11Z" />
                            @else
                                <path d="M17,9H7V7H17M17,13H7V11H17M14,17H7V15H14M12,3A1,1 0 0,1 13,4A1,1 0 0,1 12,5A1,1 0 0,1 11,4A1,1 0 0,1 12,3M19,3H14.82C14.4,1.84 13.3,1 12,1C10.7,1 9.6,1.84 9.18,3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3Z" />
                            @endif
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 mb-2 text-center">{{ $document->title }}</h3>
                    <p class="text-gray-600 text-sm mb-4 text-center">
                        {{ Str::limit($document->description, 80) }}
                    </p>
                    <div class="text-center">
                        <a href="{{ $document->file_url }}" 
                           download="{{ $document->file_name }}"
                           class="{{ $color['button'] }} text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-300">
                            Télécharger {{ strtoupper($fileExtension) }}
                            <span class="text-xs opacity-75 ml-2">({{ $document->file_size_formatted }})</span>
                        </a>
                    </div>
                </div>
            @empty
                <!-- Documents par défaut -->
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 p-6 group" data-aos="fade-up" data-aos-delay="100">
                    <div class="flex items-center justify-center w-16 h-16 bg-red-100 rounded-lg mb-4 mx-auto group-hover:bg-red-200 transition-colors duration-300">
                        <svg class="w-8 h-8 text-red-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 mb-2 text-center">Rapport Annuel 2024</h3>
                    <p class="text-gray-600 text-sm mb-4 text-center">
                        Bilan complet de nos activités et impact en 2024
                    </p>
                    <div class="text-center">
                        <span class="bg-gray-400 text-white px-4 py-2 rounded-lg text-sm font-medium">
                            Bientôt disponible
                        </span>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 p-6 group" data-aos="fade-up" data-aos-delay="200">
                    <div class="flex items-center justify-center w-16 h-16 bg-blue-100 rounded-lg mb-4 mx-auto group-hover:bg-blue-200 transition-colors duration-300">
                        <svg class="w-8 h-8 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M9,4V6H21V4H9M9,14H21V12H9V14M9,10H21V8H9V10M9,20H21V18H9V20M5,4V6H7V4H5M5,14H7V12H5V14M5,10H7V8H5V10M5,20H7V18H5V20M3,4A1,1 0 0,0 2,5V19A1,1 0 0,0 3,20H8A1,1 0 0,0 9,19V5A1,1 0 0,0 8,4H3Z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 mb-2 text-center">Guide de Prévention</h3>
                    <p class="text-gray-600 text-sm mb-4 text-center">
                        Manuel pratique pour la prévention du VIH/SIDA
                    </p>
                    <div class="text-center">
                        <span class="bg-gray-400 text-white px-4 py-2 rounded-lg text-sm font-medium">
                            Bientôt disponible
                        </span>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 p-6 group" data-aos="fade-up" data-aos-delay="300">
                    <div class="flex items-center justify-center w-16 h-16 bg-green-100 rounded-lg mb-4 mx-auto group-hover:bg-green-200 transition-colors duration-300">
                        <svg class="w-8 h-8 text-green-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20M12,11A3,3 0 0,1 15,14A3,3 0 0,1 12,17A3,3 0 0,1 9,14A3,3 0 0,1 12,11Z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 mb-2 text-center">Brochures Éducatives</h3>
                    <p class="text-gray-600 text-sm mb-4 text-center">
                        Supports visuels pour la sensibilisation
                    </p>
                    <div class="text-center">
                        <span class="bg-gray-400 text-white px-4 py-2 rounded-lg text-sm font-medium">
                            Bientôt disponible
                        </span>
                    </div>
                </div>
                
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 p-6 group" data-aos="fade-up" data-aos-delay="400">
                    <div class="flex items-center justify-center w-16 h-16 bg-purple-100 rounded-lg mb-4 mx-auto group-hover:bg-purple-200 transition-colors duration-300">
                        <svg class="w-8 h-8 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M17,9H7V7H17M17,13H7V11H17M14,17H7V15H14M12,3A1,1 0 0,1 13,4A1,1 0 0,1 12,5A1,1 0 0,1 11,4A1,1 0 0,1 12,3M19,3H14.82C14.4,1.84 13.3,1 12,1C10.7,1 9.6,1.84 9.18,3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3Z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 mb-2 text-center">Formulaires</h3>
                    <p class="text-gray-600 text-sm mb-4 text-center">
                        Documents administratifs et d'inscription
                    </p>
                    <div class="text-center">
                        <span class="bg-gray-400 text-white px-4 py-2 rounded-lg text-sm font-medium">
                            Bientôt disponible
                        </span>
                    </div>
                </div>
            @endforelse
        </div>
        
        <!-- Statistiques des téléchargements -->
        <div class="mt-16 bg-white rounded-lg shadow-lg p-8" data-aos="fade-up" data-aos-delay="500">
            <h3 class="text-xl font-bold text-gray-900 mb-6 text-center">Ressources les plus téléchargées</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-asu-600 counter" data-target="{{ $stats['documents_count'] ?? 1250 }}">0</div>
                    <div class="text-gray-600">Documents disponibles</div>
                </div>
                <div class="text-center">
                    @php
                        $totalDownloads = $featuredDocuments->sum('download_count');
                    @endphp
                    <div class="text-2xl font-bold text-asu-600 counter" data-target="{{ $totalDownloads > 0 ? $totalDownloads : 890 }}">0</div>
                    <div class="text-gray-600">Téléchargements totaux</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-asu-600 counter" data-target="{{ ($stats['articles_count'] ?? 0) + ($stats['projects_count'] ?? 0) }}">0</div>
                    <div class="text-gray-600">Ressources publiées</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ============================================================================ -->
<!-- BLOC 10: SECTION PARTENAIRES                                              -->
<!-- Début: ligne 757 - Fin: ligne 792                                          -->
<!-- Contenu: Grille de logos des partenaires institutionnels et ONG           -->
<!-- Données: $activePartners (dynamique) + partenaires fallback (@empty)      -->
<!-- ============================================================================ -->
<!-- Section Partenaires -->
<section id="partenaires" class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <!-- En-tête de section -->
        <div class="text-center mb-16" data-aos="fade-up">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Nos Partenaires</h2>
            <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                Ils nous soutiennent dans notre mission
            </p>
        </div>
        
        <!-- Grille des partenaires -->
        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-8 items-center" data-aos="fade-up" data-aos-delay="200">
            @forelse($activePartners as $partner)
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300 group">
                    @if($partner->logo)
                        <img src="{{ Storage::url($partner->logo) }}" 
                             alt="{{ $partner->name }}" 
                             class="max-h-12 max-w-full object-contain group-hover:scale-110 transition-transform duration-300"
                             title="{{ $partner->name }}">
                    @else
                        <span class="text-gray-500 font-medium text-sm text-center">{{ $partner->name }}</span>
                    @endif
                </div>
            @empty
                <!-- Partenaires par défaut -->
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300">
                    <span class="text-gray-500 font-medium text-sm">Ministère Santé</span>
                </div>
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300">
                    <span class="text-gray-500 font-medium text-sm">OMS</span>
                </div>
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300">
                    <span class="text-gray-500 font-medium text-sm">UNICEF</span>
                </div>
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300">
                    <span class="text-gray-500 font-medium text-sm">PNUD</span>
                </div>
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300">
                    <span class="text-gray-500 font-medium text-sm">Union Européenne</span>
                </div>
                <div class="bg-gray-100 rounded-lg p-6 flex items-center justify-center h-24 hover:bg-gray-200 transition-colors duration-300">
                    <span class="text-gray-500 font-medium text-sm">Croix-Rouge</span>
                </div>
            @endforelse
        </div>
    </div>
</section>

<!-- ============================================================================ -->
<!-- BLOC 11: SECTION CONTACT                                                   -->
<!-- Début: ligne 798 - Fin: ligne 890                                          -->
<!-- Contenu: Coordonnées, réseaux sociaux et formulaire de contact            -->
<!-- Données: asu_config() helpers pour contact et réseaux sociaux (dynamique) -->
<!-- ============================================================================ -->
<!-- Section Contact -->
<section id="contact" class="py-20 bg-gray-900 text-white">
    <div class="max-w-6xl mx-auto px-4">
        <!-- En-tête -->
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold mb-4">Contactez-nous</h2>
            <p class="text-lg text-gray-300 max-w-2xl mx-auto">
                Vous souhaitez nous rejoindre ou en savoir plus sur nos actions ?
            </p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Informations de contact -->
            <div>
                <h3 class="text-xl font-bold mb-6">Nos coordonnées</h3>
                <div class="space-y-4">
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                        </svg>
                        <div>
                            <div class="font-medium">Adresse</div>
                            <div class="text-gray-300">123 Avenue de la Paix, Brazzaville, République du Congo</div>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/>
                        </svg>
                        <div>
                            <div class="font-medium">Téléphone</div>
                            <div class="text-gray-300">+242 05 123 45 67</div>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-3">
                        <svg class="w-5 h-5 text-asu-400 mt-1" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                        </svg>
                        <div>
                            <div class="font-medium">Email</div>
                            <div class="text-gray-300">contact@asu-congo.org</div>
                        </div>
                    </div>
                </div>
                
                <!-- Réseaux sociaux -->
                <div class="mt-8">
                    <h4 class="font-medium mb-4">Suivez-nous</h4>
                    <div class="flex space-x-3">
                        <a href="https://facebook.com/asu.congo" class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center hover:bg-blue-700 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        
                        <a href="https://youtube.com/c/asucongo" class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center hover:bg-red-700 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                            </svg>
                        </a>
                        
                        <a href="https://instagram.com/asu_congo" class="w-10 h-10 bg-pink-600 rounded-lg flex items-center justify-center hover:bg-pink-700 transition-colors">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Formulaire de contact -->
            <div class="bg-gray-800 p-6 rounded-lg">
                <h3 class="text-xl font-bold mb-6">Envoyez-nous un message</h3>
                <form class="space-y-4">
                    <div>
                        <label for="name" class="block text-sm font-medium mb-2">Nom complet</label>
                        <input type="text" id="name" name="name" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white">
                    </div>
                    
                    <div>
                        <label for="email" class="block text-sm font-medium mb-2">Email</label>
                        <input type="email" id="email" name="email" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white">
                    </div>
                    
                    <div>
                        <label for="subject" class="block text-sm font-medium mb-2">Sujet</label>
                        <input type="text" id="subject" name="subject" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white">
                    </div>
                    
                    <div>
                        <label for="message" class="block text-sm font-medium mb-2">Message</label>
                        <textarea id="message" name="message" rows="4" class="w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-lg focus:outline-none focus:border-asu-500 text-white"></textarea>
                    </div>
                    
                    <button type="submit" class="w-full bg-asu-600 hover:bg-asu-700 text-white font-semibold py-3 px-6 rounded-lg transition-colors duration-300">
                        Envoyer le message
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-16 bg-asu-600 text-white text-center">
    <div class="max-w-4xl mx-auto px-4">
        <h2 class="text-2xl md:text-3xl font-bold mb-4">Rejoignez notre mission</h2>
        <p class="text-lg mb-8 text-asu-100">
            Ensemble, nous pouvons faire la différence dans la lutte contre le VIH/SIDA à Brazzaville.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('contact') }}" class="bg-white text-asu-600 hover:bg-gray-100 font-semibold px-6 py-3 rounded-lg transition-colors duration-300">
                Devenir bénévole
            </a>
            <a href="{{ route('contact') }}" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 font-semibold px-6 py-3 rounded-lg transition-all duration-300">
                Faire un don
            </a>
        </div>
    </div>
</section>
@endsection

<!-- ============================================================================ -->
<!-- BLOC 12: SCRIPTS JAVASCRIPT                                                -->
<!-- Début: ligne 950 - Fin: ligne 1060                                         -->
<!-- Contenu: Scripts AOS, animation compteurs, FAQ toggle, smooth scroll       -->
<!-- Fonctionnalités: Animations, interactions utilisateur, parallax            -->
<!-- ============================================================================ -->
@section('scripts')
<!-- AOS JavaScript -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script>
// Initialisation d'AOS
AOS.init({
    duration: 800,
    easing: 'ease-out-cubic',
    once: true,
    offset: 50
});

// Animation des compteurs
function animateCounters() {
    const counters = document.querySelectorAll('.counter');
    
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-target'));
        const increment = target / 100;
        let current = 0;
        
        const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                current = target;
                clearInterval(timer);
            }
            counter.textContent = Math.floor(current) + (target > 1000 ? 'K+' : '+');
        }, 20);
    });
}

// Observer pour déclencher l'animation des compteurs
const statsObserver = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            animateCounters();
            statsObserver.unobserve(entry.target);
        }
    });
}, { threshold: 0.5 });

// Observer la section des statistiques
document.addEventListener('DOMContentLoaded', () => {
    const statsSection = document.querySelector('.grid.grid-cols-2.md\\:grid-cols-4');
    if (statsSection) {
        statsObserver.observe(statsSection);
    }
});

// Fonction pour toggle FAQ
function toggleFaq(id) {
    const content = document.getElementById(`faq-content-${id}`);
    const icon = document.getElementById(`faq-icon-${id}`);
    
    if (content.classList.contains('hidden')) {
        content.classList.remove('hidden');
        icon.style.transform = 'rotate(180deg)';
    } else {
        content.classList.add('hidden');
        icon.style.transform = 'rotate(0deg)';
    }
}

// Smooth scroll pour les liens d'ancrage
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Animation parallax pour le hero
window.addEventListener('scroll', () => {
    const scrolled = window.pageYOffset;
    const heroSection = document.querySelector('.relative.min-h-screen');
    if (heroSection) {
        heroSection.style.transform = `translateY(${scrolled * 0.3}px)`;
    }
});

// Animation d'apparition en scroll
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.classList.add('animate-fade-in');
        }
    });
}, observerOptions);

// Observer tous les éléments avec data-aos
document.addEventListener('DOMContentLoaded', () => {
    const elementsToObserve = document.querySelectorAll('[data-aos]');
    elementsToObserve.forEach(el => observer.observe(el));
});
</script>
@endsection