@extends('layouts.asu')

@section('title', 'Nos Projets - Association Serment Universel')

@section('head')
<!-- AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
@endsection

@section('content')
<!-- Hero Section -->
<div class="bg-gradient-to-r from-green-600 to-green-800 text-white py-16" 
    style="background-image: url('{{ asset("storage/images/cover1.jpeg") }}'); background-size: cover; background-position: center;">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto text-center" data-aos="fade-up">
            <h1 class="text-4xl md:text-5xl font-bold mb-4">Nos Projets</h1>
            <p class="text-xl text-green-100">Découvrez nos initiatives pour le développement durable au Congo-Brazzaville</p>
        </div>
    </div>
</div>

<!-- Statistics Section -->
<div class="bg-white py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-6xl mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-12">
                <div class="text-center" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-green-100 rounded-full w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                        <svg class="w-10 h-10 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold text-gray-900">{{ $activeProjects->count() }}</h3>
                    <p class="text-gray-600">Projets en cours</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-blue-100 rounded-full w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                        <svg class="w-10 h-10 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold text-gray-900">{{ $completedProjects }}</h3>
                    <p class="text-gray-600">Projets réalisés</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-orange-100 rounded-full w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                        <svg class="w-10 h-10 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3z"></path>
                        </svg>
                    </div>
                    <h3 class="text-3xl font-bold text-gray-900">{{ number_format($totalBeneficiaries) }}+</h3>
                    <p class="text-gray-600">Bénéficiaires</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <div class="max-w-6xl mx-auto">
            <form method="GET" class="flex flex-col md:flex-row gap-4 items-center">
                <div class="w-full md:w-auto">
                    <select name="status" 
                            class="w-full md:w-auto px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">Tous les statuts</option>
                        <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>En cours</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Terminé</option>
                        <option value="planned" {{ request('status') == 'planned' ? 'selected' : '' }}>Planifié</option>
                        <option value="on_hold" {{ request('status') == 'on_hold' ? 'selected' : '' }}>En pause</option>
                    </select>
                </div>
                
                <button type="submit" 
                        class="w-full md:w-auto bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition duration-300">
                    Filtrer
                </button>
                
                @if(request('status'))
                    <a href="{{ route('projets') }}" 
                       class="w-full md:w-auto bg-gray-500 text-white px-6 py-3 rounded-lg hover:bg-gray-600 transition duration-300 text-center">
                        Réinitialiser
                    </a>
                @endif
            </form>
        </div>
    </div>
</div>

<!-- Active Projects Highlight -->
@if($activeProjects->count() > 0 && !request('status'))
<div class="bg-white py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-6xl mx-auto">
            <h2 class="text-3xl font-bold text-center mb-12">Projets en cours</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($activeProjects as $project)
                    <div class="bg-white border border-gray-200 rounded-lg overflow-hidden shadow-lg hover:shadow-xl transition duration-300">
                        @if($project->image)
                            <img src="{{ image_url($project->image) }}" 
                                 alt="{{ $project->title }}" 
                                 class="w-full h-48 object-cover">
                        @else
                            <div class="w-full h-48 bg-gradient-to-r from-blue-400 to-blue-600 flex items-center justify-center">
                                <span class="text-white text-lg font-semibold">ASU Congo</span>
                            </div>
                        @endif
                        
                        <div class="p-6">
                            <div class="flex items-center justify-between mb-3">
                                <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-semibold">
                                    {{ ucfirst(str_replace('_', ' ', $project->status)) }}
                                </span>
                                @if($project->category)
                                    <span class="text-sm text-gray-500">{{ $project->category }}</span>
                                @endif
                            </div>
                            
                            <h3 class="text-xl font-bold mb-3">
                                <a href="{{ route('project', $project->slug) }}" 
                                   class="text-gray-900 hover:text-blue-600 transition duration-300">
                                    {{ $project->title }}
                                </a>
                            </h3>
                            
                            @if($project->description)
                                <p class="text-gray-600 mb-4">{{ Str::limit($project->description, 120) }}</p>
                            @endif
                            
                            @if($project->beneficiaries)
                                <div class="text-sm text-gray-500 mb-4">
                                    <strong>{{ number_format($project->beneficiaries) }}</strong> bénéficiaires
                                </div>
                            @endif
                            
                            <div class="flex items-center justify-between">
                                <div class="text-sm text-gray-500">
                                    @if($project->start_date)
                                        Début: {{ $project->start_date->format('d/m/Y') }}
                                    @endif
                                </div>
                                <a href="{{ route('project', $project->slug) }}" 
                                   class="text-blue-600 hover:text-blue-800 font-semibold">
                                    En savoir plus →
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endif

<!-- All Projects -->
<div class="bg-gray-50 py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-6xl mx-auto">
            <div class="flex items-center justify-between mb-8">
                <h2 class="text-3xl font-bold">
                    @if(request('status'))
                        Projets {{ ucfirst(str_replace('_', ' ', request('status'))) }}
                    @else
                        Tous nos projets
                    @endif
                </h2>
                <div class="text-sm text-gray-600">
                    {{ $projects->total() }} projet{{ $projects->total() > 1 ? 's' : '' }} trouvé{{ $projects->total() > 1 ? 's' : '' }}
                </div>
            </div>

            @if($projects->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    @foreach($projects as $project)
                        <div class="bg-white rounded-lg overflow-hidden shadow-lg hover:shadow-xl transition duration-300">
                            @if($project->image)
                                <img src="{{ image_url($project->image) }}" 
                                     alt="{{ $project->title }}" 
                                     class="w-full h-48 object-cover">
                            @else
                                <div class="w-full h-48 bg-gradient-to-r from-blue-400 to-blue-600 flex items-center justify-center">
                                    <span class="text-white text-lg font-semibold">ASU Congo</span>
                                </div>
                            @endif
                            
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-3">
                                    <span class="px-3 py-1 rounded-full text-sm font-semibold
                                        @if($project->status === 'completed') bg-green-100 text-green-800
                                        @elseif($project->status === 'in_progress') bg-blue-100 text-blue-800
                                        @elseif($project->status === 'planned') bg-yellow-100 text-yellow-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ ucfirst(str_replace('_', ' ', $project->status)) }}
                                    </span>
                                    @if($project->category)
                                        <span class="text-sm text-gray-500">{{ $project->category }}</span>
                                    @endif
                                </div>
                                
                                <h3 class="text-xl font-bold mb-3">
                                    <a href="{{ route('project', $project->slug) }}" 
                                       class="text-gray-900 hover:text-blue-600 transition duration-300">
                                        {{ $project->title }}
                                    </a>
                                </h3>
                                
                                @if($project->description)
                                    <p class="text-gray-600 mb-4">{{ Str::limit($project->description, 120) }}</p>
                                @endif
                                
                                <div class="flex items-center justify-between text-sm text-gray-500 mb-4">
                                    @if($project->beneficiaries)
                                        <div>
                                            <strong>{{ number_format($project->beneficiaries) }}</strong> bénéficiaires
                                        </div>
                                    @endif
                                    @if($project->start_date)
                                        <div>
                                            {{ $project->start_date->format('d/m/Y') }}
                                        </div>
                                    @endif
                                </div>
                                
                                <div class="flex items-center justify-between">
                                    @if($project->budget)
                                        <div class="text-sm font-semibold text-green-600">
                                            Budget: {{ number_format($project->budget) }} FCFA
                                        </div>
                                    @else
                                        <div></div>
                                    @endif
                                    <a href="{{ route('project', $project->slug) }}" 
                                       class="text-blue-600 hover:text-blue-800 font-semibold">
                                        Détails →
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="mt-12">
                    {{ $projects->appends(request()->query())->links() }}
                </div>
            @else
                <!-- No Results -->
                <div class="text-center py-16">
                    <svg class="mx-auto h-24 w-24 text-gray-400 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-2m-2 0H7m5 0v-5a2 2 0 00-2-2H8a2 2 0 00-2 2v5m5 0V9a2 2 0 012-2h2a2 2 0 012 2v8M7 7h.01M7 3h.01"></path>
                    </svg>
                    <h3 class="text-2xl font-semibold text-gray-900 mb-2">Aucun projet trouvé</h3>
                    <p class="text-gray-600 mb-6">
                        @if(request('status'))
                            Aucun projet avec ce statut. Essayez de modifier vos critères de recherche.
                        @else
                            Nous travaillons sur de nouveaux projets qui seront bientôt disponibles.
                        @endif
                    </p>
                    @if(request('status'))
                        <a href="{{ route('projets') }}" 
                           class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition duration-300">
                            Voir tous les projets
                        </a>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Call to Action -->
<div class="bg-blue-600 text-white py-16">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl font-bold mb-4">Participez à nos projets</h2>
        <p class="text-xl text-blue-200 mb-8">Rejoignez-nous dans notre mission de transformation de l'enseignement supérieur</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="#" class="bg-white text-blue-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition duration-300">
                Nous soutenir
            </a>
            <a href="#" class="bg-blue-800 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-900 transition duration-300">
                Nous contacter
            </a>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<!-- AOS JavaScript -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true,
        mirror: false
    });
</script>
@endsection