@extends('layouts.asu')

@section('title', $project->title . ' - Association Serment Universel')

@section('head')
<!-- AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
@endsection

@section('content')
<!-- Hero Section -->
<section class="relative py-20 bg-gradient-to-br from-asu-600 to-asu-800 text-white">
    <div class="absolute inset-0 bg-black/20"></div>
    
    <div class="relative z-10 max-w-6xl mx-auto px-4">
        <!-- Breadcrumb -->
        <nav class="mb-8" data-aos="fade-up">
            <ol class="flex items-center space-x-2 text-sm">
                <li><a href="{{ route('home') }}" class="text-white/80 hover:text-white">Accueil</a></li>
                <li><span class="text-white/60">/</span></li>
                <li><a href="{{ route('projets') }}" class="text-white/80 hover:text-white">Projets</a></li>
                <li><span class="text-white/60">/</span></li>
                <li class="text-white">{{ $project->title }}</li>
            </ol>
        </nav>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Contenu principal -->
            <div data-aos="fade-right">
                <!-- Statut du projet -->
                <div class="mb-4">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                        @if($project->status === 'active') bg-green-500/20 text-green-300
                        @elseif($project->status === 'planned') bg-blue-500/20 text-blue-300
                        @elseif($project->status === 'completed') bg-orange-500/20 text-orange-300
                        @else bg-gray-500/20 text-gray-300
                        @endif">
                        @if($project->status === 'active') ✓ En cours
                        @elseif($project->status === 'planned') 📅 Planifié
                        @elseif($project->status === 'completed') ✅ Terminé
                        @else {{ ucfirst($project->status) }}
                        @endif
                    </span>
                </div>

                <h1 class="text-4xl md:text-5xl font-bold mb-6">{{ $project->title }}</h1>
                
                <p class="text-xl text-white/90 mb-8 leading-relaxed">
                    {{ $project->description }}
                </p>

                <!-- Informations clés -->
                <div class="grid grid-cols-2 gap-6 mb-8">
                    @if($project->start_date && $project->end_date)
                        <div>
                            <div class="text-sm text-white/70 uppercase tracking-wide">Période</div>
                            <div class="text-lg font-semibold">
                                {{ $project->start_date->format('M Y') }} - {{ $project->end_date->format('M Y') }}
                            </div>
                        </div>
                    @endif
                    
                    @if($project->budget)
                        <div>
                            <div class="text-sm text-white/70 uppercase tracking-wide">Budget</div>
                            <div class="text-lg font-semibold">
                                {{ number_format($project->budget, 0, ',', ' ') }}€
                            </div>
                        </div>
                    @endif
                    
                    @if($project->beneficiaries)
                        <div>
                            <div class="text-sm text-white/70 uppercase tracking-wide">Bénéficiaires</div>
                            <div class="text-lg font-semibold">
                                {{ number_format($project->beneficiaries) }} personnes
                            </div>
                        </div>
                    @endif
                    
                    @if($project->progress_percentage !== null)
                        <div>
                            <div class="text-sm text-white/70 uppercase tracking-wide">Progression</div>
                            <div class="text-lg font-semibold">{{ $project->progress_percentage }}%</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Image du projet -->
            <div class="relative" data-aos="fade-left">
                @if($project->featured_image)
                    <img src="{{ Storage::url($project->featured_image) }}" 
                         alt="{{ $project->title }}" 
                         class="rounded-lg shadow-2xl w-full hover:scale-105 transition-transform duration-300">
                @else
                    <div class="w-full h-96 bg-white/10 rounded-lg flex items-center justify-center">
                        <svg class="w-24 h-24 text-white/50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                @endif
                <div class="absolute inset-0 bg-asu-600/10 rounded-lg"></div>
            </div>
        </div>
    </div>
</section>

<!-- Barre de progression -->
@if($project->progress_percentage !== null)
<section class="py-8 bg-white">
    <div class="max-w-6xl mx-auto px-4" data-aos="fade-up">
        <div class="bg-gray-200 rounded-full h-3 overflow-hidden">
            <div class="h-full bg-gradient-to-r from-asu-500 to-asu-600 rounded-full transition-all duration-1000" 
                 style="width: {{ $project->progress_percentage }}%"></div>
        </div>
        <div class="flex justify-between items-center mt-2 text-sm text-gray-600">
            <span>Progression du projet</span>
            <span class="font-semibold">{{ $project->progress_percentage }}% complété</span>
        </div>
    </div>
</section>
@endif

<!-- Contenu détaillé -->
<section class="py-20 bg-gray-50">
    <div class="max-w-4xl mx-auto px-4">
        <div class="bg-white rounded-lg shadow-lg p-8" data-aos="fade-up">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">Description détaillée du projet</h2>
            
            @if($project->content)
                <div class="prose prose-lg max-w-none text-gray-700">
                    {!! nl2br(e($project->content)) !!}
                </div>
            @else
                <div class="text-gray-600 leading-relaxed">
                    <p class="mb-4">{{ $project->description }}</p>
                    <p>Ce projet fait partie de nos initiatives visant à améliorer la prévention du VIH/SIDA et l'accompagnement psychosocial en République du Congo.</p>
                </div>
            @endif
        </div>
    </div>
</section>

<!-- Objectifs et résultats -->
<section class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Objectifs -->
            <div data-aos="fade-right">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Objectifs du projet</h2>
                @if($project->objectives)
                    <ul class="space-y-3">
                        @foreach(explode("\n", $project->objectives) as $objective)
                            @if(trim($objective))
                                <li class="flex items-start space-x-3">
                                    <div class="w-2 h-2 bg-asu-600 rounded-full mt-2 flex-shrink-0"></div>
                                    <span class="text-gray-700">{{ trim($objective) }}</span>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                @else
                    <div class="space-y-3">
                        <div class="flex items-start space-x-3">
                            <div class="w-2 h-2 bg-asu-600 rounded-full mt-2 flex-shrink-0"></div>
                            <span class="text-gray-700">Améliorer la prévention et l'éducation sur le VIH/SIDA</span>
                        </div>
                        <div class="flex items-start space-x-3">
                            <div class="w-2 h-2 bg-asu-600 rounded-full mt-2 flex-shrink-0"></div>
                            <span class="text-gray-700">Accompagner les personnes concernées</span>
                        </div>
                        <div class="flex items-start space-x-3">
                            <div class="w-2 h-2 bg-asu-600 rounded-full mt-2 flex-shrink-0"></div>
                            <span class="text-gray-700">Renforcer les capacités communautaires</span>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Résultats -->
            <div data-aos="fade-left">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">
                    @if($project->status === 'completed') Résultats obtenus
                    @else Résultats attendus
                    @endif
                </h2>
                @if($project->results)
                    <ul class="space-y-3">
                        @foreach(explode("\n", $project->results) as $result)
                            @if(trim($result))
                                <li class="flex items-start space-x-3">
                                    <div class="w-5 h-5 text-green-600 flex-shrink-0 mt-0.5">
                                        @if($project->status === 'completed')
                                            <svg fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                        @else
                                            <svg fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                                            </svg>
                                        @endif
                                    </div>
                                    <span class="text-gray-700">{{ trim($result) }}</span>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                @else
                    <div class="space-y-3">
                        <div class="flex items-start space-x-3">
                            <div class="w-5 h-5 text-green-600 flex-shrink-0 mt-0.5">
                                <svg fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <span class="text-gray-700">Impact positif sur la communauté</span>
                        </div>
                        <div class="flex items-start space-x-3">
                            <div class="w-5 h-5 text-green-600 flex-shrink-0 mt-0.5">
                                <svg fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <span class="text-gray-700">Amélioration des connaissances</span>
                        </div>
                        <div class="flex items-start space-x-3">
                            <div class="w-5 h-5 text-green-600 flex-shrink-0 mt-0.5">
                                <svg fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <span class="text-gray-700">Renforcement des partenariats</span>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</section>

<!-- Projets similaires -->
@if($relatedProjects->isNotEmpty())
<section class="py-20 bg-gray-50">
    <div class="max-w-6xl mx-auto px-4">
        <div class="text-center mb-12" data-aos="fade-up">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">Autres projets</h2>
            <p class="text-lg text-gray-600">Découvrez nos autres initiatives</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            @foreach($relatedProjects as $index => $relatedProject)
                <div class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                    @if($relatedProject->featured_image)
                        <img src="{{ Storage::url($relatedProject->featured_image) }}" 
                             alt="{{ $relatedProject->title }}" 
                             class="w-full h-48 object-cover">
                    @else
                        <div class="w-full h-48 bg-gradient-to-br from-asu-500 to-asu-700 flex items-center justify-center">
                            <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                    @endif
                    
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-3">
                            <span class="text-sm font-medium
                                @if($relatedProject->status === 'active') text-green-600
                                @elseif($relatedProject->status === 'planned') text-blue-600
                                @elseif($relatedProject->status === 'completed') text-orange-600
                                @else text-gray-600
                                @endif">
                                @if($relatedProject->status === 'active') En cours
                                @elseif($relatedProject->status === 'planned') Planifié
                                @elseif($relatedProject->status === 'completed') Terminé
                                @else {{ ucfirst($relatedProject->status) }}
                                @endif
                            </span>
                            @if($relatedProject->progress_percentage !== null)
                                <span class="text-sm text-gray-500">{{ $relatedProject->progress_percentage }}%</span>
                            @endif
                        </div>
                        
                        <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $relatedProject->title }}</h3>
                        <p class="text-gray-600 mb-4">
                            {{ Str::limit($relatedProject->description, 120) }}
                        </p>
                        
                        <a href="{{ route('project', $relatedProject->slug) }}" 
                           class="text-asu-600 hover:text-asu-700 font-medium">
                            En savoir plus →
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Call to action -->
<section class="py-20 bg-asu-600 text-white">
    <div class="max-w-4xl mx-auto px-4 text-center" data-aos="fade-up">
        <h2 class="text-3xl font-bold mb-4">Soutenez nos actions</h2>
        <p class="text-xl text-white/90 mb-8">
            Votre soutien nous permet de continuer à œuvrer pour la prévention du VIH/SIDA et l'accompagnement des personnes concernées.
        </p>
        
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('contact') }}" class="bg-white text-asu-600 hover:bg-gray-100 font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                Nous contacter
            </a>
            <a href="#" class="border-2 border-white text-white hover:bg-white hover:text-asu-600 font-semibold px-8 py-3 rounded-lg transition-all duration-300">
                Devenir bénévole
            </a>
        </div>
    </div>
</section>
@endsection

@section('scripts')
<!-- AOS JavaScript -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script>
// Initialisation d'AOS
AOS.init({
    duration: 800,
    easing: 'ease-out-cubic',
    once: true,
    offset: 50
});

// Animation de la barre de progression
document.addEventListener('DOMContentLoaded', function() {
    const progressBar = document.querySelector('.bg-gradient-to-r');
    if (progressBar) {
        // Animation retardée pour un effet visuel
        setTimeout(() => {
            progressBar.style.transition = 'width 2s ease-out';
        }, 500);
    }
});
</script>
@endsection