@extends('layouts.asu')

@section('title', 'Galerie - Photos et Vidéos')

@section('content')
<!-- Hero Section -->
<section class="relative bg-gradient-to-r from-blue-600 to-green-600 text-white py-20">
    <div class="absolute inset-0 bg-black bg-opacity-30"></div>
    <div class="relative container mx-auto px-4 text-center">
        <h1 class="text-4xl md:text-5xl font-bold mb-4">Galerie</h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto">
            Découvrez nos actions sur le terrain à travers nos photos et vidéos
        </p>
        <div class="flex flex-wrap justify-center gap-4 text-sm">
            <span class="bg-white bg-opacity-20 px-4 py-2 rounded-full">
                <i class="fas fa-images mr-2"></i>{{ $images->total() }} Photos
            </span>
            <span class="bg-white bg-opacity-20 px-4 py-2 rounded-full">
                <i class="fas fa-video mr-2"></i>{{ $videos->count() }} Vidéos
            </span>
        </div>
    </div>
</section>

<!-- Navigation Tabs -->
<section class="bg-white py-6 shadow-sm">
    <div class="container mx-auto px-4">
        <div class="flex justify-center">
            <div class="flex bg-gray-100 rounded-lg p-1">
                <button id="photos-tab" class="px-6 py-3 rounded-md bg-blue-600 text-white font-medium transition-all">
                    <i class="fas fa-images mr-2"></i>Photos
                </button>
                <button id="videos-tab" class="px-6 py-3 rounded-md text-gray-600 hover:text-blue-600 font-medium transition-all">
                    <i class="fas fa-video mr-2"></i>Vidéos
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Photos Gallery -->
<section id="photos-section" class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        @if($images->count() > 0)
            <!-- Photos Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-12">
                @foreach($images as $image)
                    <div class="group cursor-pointer" onclick="openLightbox('{{ $image->image_url }}', '{{ $image->title }}')">
                        <div class="relative overflow-hidden rounded-lg shadow-lg">
                            <img src="{{ $image->thumbnail_url ?? $image->image_url }}" 
                                 alt="{{ $image->alt_text ?? $image->title }}" 
                                 class="w-full h-64 object-cover transition-transform duration-300 group-hover:scale-110">
                            <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-30 transition-all duration-300 flex items-center justify-center">
                                <i class="fas fa-expand-alt text-white opacity-0 group-hover:opacity-100 text-2xl transition-all duration-300"></i>
                            </div>
                        </div>
                        @if($image->title)
                            <div class="mt-3">
                                <h3 class="font-medium text-gray-900">{{ $image->title }}</h3>
                                @if($image->description)
                                    <p class="text-sm text-gray-600 mt-1">{{ Str::limit($image->description, 100) }}</p>
                                @endif
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="flex justify-center">
                {{ $images->links() }}
            </div>
        @else
            <div class="text-center py-16">
                <i class="fas fa-images text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-medium text-gray-900 mb-2">Aucune photo disponible</h3>
                <p class="text-gray-600">Les photos seront bientôt disponibles.</p>
            </div>
        @endif
    </div>
</section>

<!-- Videos Gallery -->
<section id="videos-section" class="py-16 bg-gray-50 hidden">
    <div class="container mx-auto px-4">
        @if($videos->count() > 0)
            <!-- Videos Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($videos as $video)
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                        <div class="relative">
                            @if($video->thumbnail_url)
                                <img src="{{ $video->thumbnail_url }}" 
                                     alt="{{ $video->title }}" 
                                     class="w-full h-48 object-cover">
                            @else
                                <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                                    <i class="fas fa-video text-gray-400 text-4xl"></i>
                                </div>
                            @endif
                            <div class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center">
                                <button onclick="playVideo('{{ $video->video_url }}', '{{ $video->title }}')" 
                                        class="bg-white bg-opacity-90 hover:bg-opacity-100 rounded-full p-4 transition-all">
                                    <i class="fas fa-play text-blue-600 text-xl ml-1"></i>
                                </button>
                            </div>
                        </div>
                        <div class="p-4">
                            <h3 class="font-medium text-gray-900 mb-2">{{ $video->title }}</h3>
                            @if($video->description)
                                <p class="text-sm text-gray-600">{{ Str::limit($video->description, 120) }}</p>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-16">
                <i class="fas fa-video text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-medium text-gray-900 mb-2">Aucune vidéo disponible</h3>
                <p class="text-gray-600">Les vidéos seront bientôt disponibles.</p>
            </div>
        @endif
    </div>
</section>

<!-- Lightbox Modal -->
<div id="lightbox" class="fixed inset-0 bg-black bg-opacity-90 z-50 hidden items-center justify-center p-4">
    <div class="relative max-w-6xl max-h-full">
        <button onclick="closeLightbox()" class="absolute -top-12 right-0 text-white hover:text-gray-300 text-2xl">
            <i class="fas fa-times"></i>
        </button>
        <img id="lightbox-image" src="" alt="" class="max-w-full max-h-full object-contain">
        <div id="lightbox-caption" class="absolute bottom-0 left-0 right-0 bg-black bg-opacity-70 text-white p-4 text-center"></div>
    </div>
</div>

<!-- Video Modal -->
<div id="video-modal" class="fixed inset-0 bg-black bg-opacity-90 z-50 hidden items-center justify-center p-4">
    <div class="relative max-w-4xl w-full">
        <button onclick="closeVideo()" class="absolute -top-12 right-0 text-white hover:text-gray-300 text-2xl">
            <i class="fas fa-times"></i>
        </button>
        <div class="relative pb-56.25 h-0">
            <iframe id="video-frame" 
                    src="" 
                    class="absolute top-0 left-0 w-full h-full" 
                    frameborder="0" 
                    allowfullscreen></iframe>
        </div>
        <div id="video-caption" class="bg-black bg-opacity-70 text-white p-4 text-center"></div>
    </div>
</div>

@push('scripts')
<script>
// Tab functionality
document.getElementById('photos-tab').addEventListener('click', function() {
    showSection('photos');
    this.classList.add('bg-blue-600', 'text-white');
    this.classList.remove('text-gray-600');
    document.getElementById('videos-tab').classList.remove('bg-blue-600', 'text-white');
    document.getElementById('videos-tab').classList.add('text-gray-600');
});

document.getElementById('videos-tab').addEventListener('click', function() {
    showSection('videos');
    this.classList.add('bg-blue-600', 'text-white');
    this.classList.remove('text-gray-600');
    document.getElementById('photos-tab').classList.remove('bg-blue-600', 'text-white');
    document.getElementById('photos-tab').classList.add('text-gray-600');
});

function showSection(section) {
    document.getElementById('photos-section').classList.toggle('hidden', section !== 'photos');
    document.getElementById('videos-section').classList.toggle('hidden', section !== 'videos');
}

// Lightbox functionality
function openLightbox(src, caption) {
    document.getElementById('lightbox-image').src = src;
    document.getElementById('lightbox-caption').textContent = caption || '';
    document.getElementById('lightbox').classList.remove('hidden');
    document.getElementById('lightbox').classList.add('flex');
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    document.getElementById('lightbox').classList.add('hidden');
    document.getElementById('lightbox').classList.remove('flex');
    document.body.style.overflow = 'auto';
}

// Video modal functionality
function playVideo(url, title) {
    // Convertir l'URL YouTube en URL d'embed si nécessaire
    let embedUrl = url;
    if (url && url.includes('youtube.com/watch')) {
        const videoId = url.split('v=')[1].split('&')[0];
        embedUrl = `https://www.youtube.com/embed/${videoId}`;
    } else if (url && url.includes('youtu.be/')) {
        const videoId = url.split('youtu.be/')[1];
        embedUrl = `https://www.youtube.com/embed/${videoId}`;
    }
    
    document.getElementById('video-frame').src = embedUrl;
    document.getElementById('video-caption').textContent = title || '';
    document.getElementById('video-modal').classList.remove('hidden');
    document.getElementById('video-modal').classList.add('flex');
    document.body.style.overflow = 'hidden';
}

function closeVideo() {
    document.getElementById('video-frame').src = '';
    document.getElementById('video-modal').classList.add('hidden');
    document.getElementById('video-modal').classList.remove('flex');
    document.body.style.overflow = 'auto';
}

// Close modals with Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLightbox();
        closeVideo();
    }
});

// Close modals when clicking outside
document.getElementById('lightbox').addEventListener('click', function(e) {
    if (e.target === this) {
        closeLightbox();
    }
});

document.getElementById('video-modal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeVideo();
    }
});
</script>
@endpush
@endsection
