@props([
    'src' => null,
    'alt' => '',
    'class' => '',
    'width' => null,
    'height' => null,
    'fallback' => 'images/placeholder.jpg',
    'lazy' => true,
    'rounded' => false,
    'circle' => false
])

@php
    $imageUrl = image_url($src, $fallback);
    
    $classes = collect([
        $class,
        $rounded ? 'rounded-lg' : '',
        $circle ? 'rounded-full' : '',
    ])->filter()->implode(' ');
    
    $attributes = collect([
        'src' => $imageUrl,
        'alt' => $alt,
        'class' => $classes,
        'loading' => $lazy ? 'lazy' : null,
        'width' => $width,
        'height' => $height,
    ])->filter()->toArray();
@endphp

@if($imageUrl)
    <img {{ collect($attributes)->map(fn($value, $key) => "{$key}=\"{$value}\"")->implode(' ') }}>
@else
    <div class="flex items-center justify-center bg-gray-200 {{ $classes }}" 
         @if($width) style="width: {{ $width }}px;" @endif
         @if($height) style="height: {{ $height }}px;" @endif>
        <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
        </svg>
    </div>
@endif