@props([
    'name',
    'label' => null,
    'value' => null,
    'required' => false,
    'accept' => 'image/*',
    'multiple' => false,
    'preview' => true,
    'previewSize' => 'w-32 h-32',
    'help' => null
])

@php
    $id = $attributes->get('id', $name);
    $currentImage = old($name, $value);
@endphp

<div class="space-y-2">
    @if($label)
        <label for="{{ $id }}" class="block text-sm font-medium text-gray-700">
            {{ $label }}
            @if($required) <span class="text-red-500">*</span> @endif
        </label>
    @endif
    
    @if($preview && $currentImage)
        <div class="mb-4">
            @if(is_array($currentImage))
                <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                    @foreach($currentImage as $index => $image)
                        <div class="relative">
                            <x-image 
                                :src="$image" 
                                :alt="'Image ' . ($index + 1)"
                                :class="$previewSize . ' object-cover rounded-lg'" 
                            />
                            <button type="button" 
                                    onclick="removePreviewImage({{ $index }})"
                                    class="absolute -top-2 -right-2 bg-red-500 text-white rounded-full w-6 h-6 flex items-center justify-center text-xs hover:bg-red-600">
                                ×
                            </button>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="relative inline-block">
                    <x-image 
                        :src="$currentImage" 
                        alt="Image actuelle"
                        :class="$previewSize . ' object-cover rounded-lg'" 
                    />
                    <p class="text-sm text-gray-500 mt-1">Image actuelle</p>
                </div>
            @endif
        </div>
    @endif
    
    <input 
        type="file"
        name="{{ $name }}"
        id="{{ $id }}"
        accept="{{ $accept }}"
        @if($multiple) multiple @endif
        @if($required) required @endif
        {{ $attributes->merge(['class' => 'w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500']) }}
        onchange="previewImages(this)"
    >
    
    @if($help)
        <p class="text-sm text-gray-500">{{ $help }}</p>
    @endif
    
    @error($name)
        <p class="text-sm text-red-600">{{ $message }}</p>
    @enderror
    
    <!-- Preview container for new images -->
    <div id="{{ $id }}_preview" class="mt-4 grid grid-cols-2 md:grid-cols-3 gap-4 hidden"></div>
</div>

<script>
function previewImages(input) {
    const previewContainer = document.getElementById(input.id + '_preview');
    previewContainer.innerHTML = '';
    previewContainer.classList.add('hidden');
    
    if (input.files && input.files.length > 0) {
        previewContainer.classList.remove('hidden');
        
        Array.from(input.files).forEach((file, index) => {
            if (file.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = 'relative';
                    div.innerHTML = `
                        <img src="${e.target.result}" 
                             alt="Aperçu ${index + 1}" 
                             class="{{ $previewSize }} object-cover rounded-lg border">
                        <div class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center opacity-0 hover:opacity-100 transition-opacity rounded-lg">
                            <span class="text-white text-xs">Nouvel upload</span>
                        </div>
                    `;
                    previewContainer.appendChild(div);
                };
                reader.readAsDataURL(file);
            }
        });
    }
}

function removePreviewImage(index) {
    // Cette fonction doit être implémentée côté serveur pour supprimer l'image
    if (confirm('Supprimer cette image ?')) {
        // Logique de suppression à implémenter
        location.reload();
    }
}
</script>