@props([
    'route',
    'model',
    'itemName' => null,
    'itemType' => 'élément',
    'class' => '',
    'size' => 'md',
    'variant' => 'danger',
    'confirm' => true,
    'text' => 'Supprimer'
])

@php
    $sizeClasses = [
        'sm' => 'px-3 py-1 text-sm',
        'md' => 'px-4 py-2 text-sm',
        'lg' => 'px-6 py-3 text-base'
    ];

    $variantClasses = [
        'danger' => 'bg-red-600 text-white hover:bg-red-700 focus:ring-red-500',
        'outline' => 'border border-red-600 text-red-600 hover:bg-red-50 focus:ring-red-500',
        'ghost' => 'text-red-600 hover:bg-red-50 focus:ring-red-500'
    ];

    $classes = implode(' ', [
        'inline-flex items-center justify-center',
        'font-medium rounded-lg',
        'transition duration-300',
        'focus:outline-none focus:ring-2 focus:ring-offset-2',
        $sizeClasses[$size] ?? $sizeClasses['md'],
        $variantClasses[$variant] ?? $variantClasses['danger'],
        $class
    ]);

    $displayName = $itemName ?? ($model->title ?? $model->name ?? $model->label ?? 'cet élément');
@endphp

<form action="{{ route($route, $model) }}" 
      method="POST" 
      class="inline delete-form"
      data-item-name="{{ $displayName }}"
      data-item-type="{{ $itemType }}"
      @if(!$confirm) onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer {{ $displayName }} ?')" @endif>
    @csrf
    @method('DELETE')
    
    <button type="submit" class="{{ $classes }}">
        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
        </svg>
        {{ $text }}
    </button>
</form>