@extends('layouts.app')

@section('title', $article->title . ' - ASU Congo')

@section('meta')
    <meta name="description" content="{{ Str::limit(strip_tags($article->content), 160) }}">
    <meta property="og:title" content="{{ $article->title }}">
    <meta property="og:description" content="{{ Str::limit(strip_tags($article->content), 160) }}">
    @if($article->featured_image)
        <meta property="og:image" content="{{ image_url($article->featured_image) }}">
    @endif
    <meta property="og:url" content="{{ route('article', $article->slug) }}">
    <meta property="og:type" content="article">
@endsection

@section('content')
<!-- Article Hero Section -->
<div class="bg-gradient-to-r from-blue-600 to-blue-800 text-white py-16 style="background-image: url('{{ asset("storage/utiles/cover1.jpg") }}'); background-size: cover; background-position: center; background-blend-mode: overlay;">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <!-- Breadcrumb -->
            <nav class="text-sm mb-4">
                <a href="{{ route('home') }}" class="text-blue-200 hover:text-white">Accueil</a>
                <span class="mx-2">/</span>
                <a href="{{ route('actualites') }}" class="text-blue-200 hover:text-white">Actualités</a>
                <span class="mx-2">/</span>
                <span class="text-white">{{ $article->title }}</span>
            </nav>

            <!-- Category Badge -->
            <div class="mb-4">
                <span class="inline-block bg-blue-500 text-white px-3 py-1 rounded-full text-sm font-semibold">
                    {{ ucfirst($article->category) }}
                </span>
                @if($article->is_featured)
                    <span class="inline-block bg-yellow-500 text-white px-3 py-1 rounded-full text-sm font-semibold ml-2">
                        À la Une
                    </span>
                @endif
            </div>

            <!-- Article Title -->
            <h1 class="text-4xl md:text-5xl font-bold mb-4">{{ $article->title }}</h1>

            <!-- Article Meta -->
            <div class="flex flex-wrap items-center text-blue-200 text-sm">
                <div class="flex items-center mr-6 mb-2">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                    </svg>
                    Par {{ $article->author->name ?? 'Équipe ASU' }}
                </div>
                <div class="flex items-center mr-6 mb-2">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"></path>
                    </svg>
                    {{ $article->published_at->format('d/m/Y') }}
                </div>
                @if($article->reading_time)
                    <div class="flex items-center mb-2">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                        </svg>
                        {{ $article->reading_time }} min de lecture
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Article Content -->
<div class="bg-white py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
                <!-- Main Content -->
                <div class="lg:col-span-2">
                    <!-- Featured Image -->
                    @if($article->featured_image)
                        <div class="mb-8">
                            <img src="{{ image_url($article->featured_image) }}" 
                                 alt="{{ $article->title }}" 
                                 class="w-full h-64 md:h-96 object-cover rounded-lg shadow-lg">
                        </div>
                    @endif

                    <!-- Article Excerpt -->
                    @if($article->excerpt)
                        <div class="bg-blue-50 border-l-4 border-blue-500 p-6 mb-8">
                            <p class="text-lg text-gray-700 leading-relaxed italic">{{ $article->excerpt }}</p>
                        </div>
                    @endif

                    <!-- Article Content -->
                    <div class="prose prose-lg max-w-none">
                        {!! $article->content !!}
                    </div>

                    <!-- Tags -->
                    @if($article->tags)
                        <div class="mt-12 pt-8 border-t">
                            <h3 class="text-lg font-semibold mb-4">Mots-clés :</h3>
                            <div class="flex flex-wrap gap-2">
                                @foreach(explode(',', $article->tags) as $tag)
                                    <span class="bg-gray-100 text-gray-700 px-3 py-1 rounded-full text-sm">
                                        {{ trim($tag) }}
                                    </span>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- Share Buttons -->
                    <div class="mt-8 pt-8 border-t">
                        <h3 class="text-lg font-semibold mb-4">Partager cet article :</h3>
                        <div class="flex space-x-4">
                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(route('article', $article->slug)) }}" 
                               target="_blank" 
                               class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                                Facebook
                            </a>
                            <a href="https://twitter.com/intent/tweet?url={{ urlencode(route('article', $article->slug)) }}&text={{ urlencode($article->title) }}" 
                               target="_blank" 
                               class="bg-sky-500 text-white px-4 py-2 rounded-lg hover:bg-sky-600 transition duration-300">
                                Twitter
                            </a>
                            <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode(route('article', $article->slug)) }}" 
                               target="_blank" 
                               class="bg-blue-700 text-white px-4 py-2 rounded-lg hover:bg-blue-800 transition duration-300">
                                LinkedIn
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="lg:col-span-1">
                    <!-- Related Articles -->
                    @if($relatedArticles->count() > 0)
                        <div class="bg-gray-50 p-6 rounded-lg">
                            <h3 class="text-xl font-bold mb-6">Articles similaires</h3>
                            <div class="space-y-4">
                                @foreach($relatedArticles as $related)
                                    <article class="border-b border-gray-200 pb-4 last:border-b-0">
                                        @if($related->featured_image)
                                            <img src="{{ image_url($related->featured_image) }}" 
                                                 alt="{{ $related->title }}" 
                                                 class="w-full h-32 object-cover rounded mb-3">
                                        @endif
                                        <h4 class="font-semibold mb-2">
                                            <a href="{{ route('article', $related->slug) }}" 
                                               class="text-gray-900 hover:text-blue-600 transition duration-300">
                                                {{ $related->title }}
                                            </a>
                                        </h4>
                                        <p class="text-sm text-gray-600 mb-2">{{ Str::limit($related->excerpt, 100) }}</p>
                                        <div class="text-xs text-gray-500">
                                            {{ $related->published_at->format('d/m/Y') }}
                                        </div>
                                    </article>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- Newsletter Signup -->
                    <div class="bg-blue-600 text-white p-6 rounded-lg mt-8">
                        <h3 class="text-xl font-bold mb-4">Restez informé</h3>
                        <p class="mb-4">Recevez nos dernières actualités directement dans votre boîte mail.</p>
                        <form action="#" method="POST" class="space-y-3">
                            @csrf
                            <input type="email" 
                                   name="email" 
                                   placeholder="Votre adresse email" 
                                   class="w-full px-3 py-2 text-gray-900 rounded focus:outline-none focus:ring-2 focus:ring-blue-300"
                                   required>
                            <button type="submit" 
                                    class="w-full bg-blue-800 text-white py-2 rounded hover:bg-blue-900 transition duration-300">
                                S'abonner
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Navigation Article -->
<div class="bg-gray-100 py-8">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <div class="flex justify-center">
                <a href="{{ route('actualites') }}" 
                   class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition duration-300 flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                    </svg>
                    Retour aux actualités
                </a>
            </div>
        </div>
    </div>
</div>
@endsection