@extends('layouts.admin')

@section('title', 'Modifier le Paramètre')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Modifier le Paramètre</h1>
            <a href="{{ route('admin.settings.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                Retour à la liste
            </a>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-2xl mx-auto">
            <form action="{{ route('admin.settings.update', $setting) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
                @csrf
                @method('PUT')
                
                <!-- Key -->
                <div>
                    <label for="key" class="block text-sm font-medium text-gray-700 mb-2">Clé *</label>
                    <input type="text" 
                           name="key" 
                           id="key" 
                           value="{{ old('key', $setting->key) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('key') border-red-500 @enderror"
                           required>
                    @error('key')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Label -->
                <div>
                    <label for="label" class="block text-sm font-medium text-gray-700 mb-2">Libellé *</label>
                    <input type="text" 
                           name="label" 
                           id="label" 
                           value="{{ old('label', $setting->label) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('label') border-red-500 @enderror"
                           required>
                    @error('label')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Type -->
                <div>
                    <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                    <select name="type" 
                            id="type" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('type') border-red-500 @enderror"
                            onchange="toggleValueFields()"
                            required>
                        <option value="">Sélectionnez un type</option>
                        <option value="text" {{ old('type', $setting->type) == 'text' ? 'selected' : '' }}>Texte</option>
                        <option value="textarea" {{ old('type', $setting->type) == 'textarea' ? 'selected' : '' }}>Zone de texte</option>
                        <option value="number" {{ old('type', $setting->type) == 'number' ? 'selected' : '' }}>Nombre</option>
                        <option value="email" {{ old('type', $setting->type) == 'email' ? 'selected' : '' }}>Email</option>
                        <option value="url" {{ old('type', $setting->type) == 'url' ? 'selected' : '' }}>URL</option>
                        <option value="tel" {{ old('type', $setting->type) == 'tel' ? 'selected' : '' }}>Téléphone</option>
                        <option value="select" {{ old('type', $setting->type) == 'select' ? 'selected' : '' }}>Liste déroulante</option>
                        <option value="checkbox" {{ old('type', $setting->type) == 'checkbox' ? 'selected' : '' }}>Case à cocher</option>
                        <option value="file" {{ old('type', $setting->type) == 'file' ? 'selected' : '' }}>Fichier</option>
                        <option value="image" {{ old('type', $setting->type) == 'image' ? 'selected' : '' }}>Image</option>
                        <option value="color" {{ old('type', $setting->type) == 'color' ? 'selected' : '' }}>Couleur</option>
                        <option value="date" {{ old('type', $setting->type) == 'date' ? 'selected' : '' }}>Date</option>
                        <option value="time" {{ old('type', $setting->type) == 'time' ? 'selected' : '' }}>Heure</option>
                        <option value="json" {{ old('type', $setting->type) == 'json' ? 'selected' : '' }}>JSON</option>
                    </select>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Value (Text/Textarea/Number/Email/URL/Tel) -->
                <div id="value-text" class="value-field">
                    <label for="value" class="block text-sm font-medium text-gray-700 mb-2">Valeur</label>
                    <input type="text" 
                           name="value" 
                           id="value" 
                           value="{{ old('value', in_array($setting->type, ['text', 'number', 'email', 'url', 'tel', 'color', 'date', 'time']) ? $setting->value : '') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('value') border-red-500 @enderror">
                    @error('value')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Value Textarea -->
                <div id="value-textarea" class="value-field" style="display: none;">
                    <label for="value_textarea" class="block text-sm font-medium text-gray-700 mb-2">Valeur</label>
                    <textarea name="value_textarea" 
                              id="value_textarea" 
                              rows="4"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">{{ old('value_textarea', $setting->type == 'textarea' ? $setting->value : '') }}</textarea>
                </div>

                <!-- Value JSON -->
                <div id="value-json" class="value-field" style="display: none;">
                    <label for="value_json" class="block text-sm font-medium text-gray-700 mb-2">Valeur JSON</label>
                    <textarea name="value_json" 
                              id="value_json" 
                              rows="6"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">{{ old('value_json', $setting->type == 'json' ? $setting->value : '') }}</textarea>
                    <p class="mt-1 text-sm text-gray-500">Format JSON valide requis</p>
                </div>

                <!-- Value File/Image -->
                <div id="value-file" class="value-field" style="display: none;">
                    <label for="file" class="block text-sm font-medium text-gray-700 mb-2">Fichier</label>
                    @if($setting->value && in_array($setting->type, ['file', 'image']))
                        <div class="mb-4">
                            @if($setting->type == 'image' && file_exists_storage($setting->value))
                                <x-image 
                                    :src="$setting->value" 
                                    alt="Image actuelle" 
                                    class="w-32 h-32 object-cover rounded-lg"
                                />
                            @elseif($setting->type == 'file' && file_exists_storage($setting->value))
                                <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                                    <i class="{{ get_file_icon($setting->value) }} mr-3"></i>
                                    <div>
                                        <span class="text-sm text-gray-700">{{ basename($setting->value) }}</span>
                                        <p class="text-xs text-gray-500">{{ formatBytes(get_file_size_storage($setting->value)) }}</p>
                                    </div>
                                </div>
                            @endif
                            <p class="text-sm text-gray-500 mt-1">Fichier actuel</p>
                        </div>
                    @endif
                    <input type="file" 
                           name="file" 
                           id="file" 
                           accept="{{ $setting->type == 'image' ? 'image/*' : '*' }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    @if($setting->type == 'image')
                        <p class="mt-1 text-sm text-gray-500">Formats acceptés: JPG, PNG, GIF, WebP (Max: 5MB)</p>
                    @else
                        <p class="mt-1 text-sm text-gray-500">Tous types de fichiers acceptés (Max: 10MB)</p>
                    @endif
                </div>

                <!-- Value Checkbox -->
                <div id="value-checkbox" class="value-field" style="display: none;">
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="value_checkbox" 
                               id="value_checkbox" 
                               value="1"
                               {{ old('value_checkbox', $setting->type == 'checkbox' && $setting->value == '1') ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="value_checkbox" class="ml-2 text-sm text-gray-700">Activé</label>
                    </div>
                </div>

                <!-- Options (for select) -->
                <div id="options-field" style="display: none;">
                    <label for="options" class="block text-sm font-medium text-gray-700 mb-2">Options (une par ligne)</label>
                    <textarea name="options" 
                              id="options" 
                              rows="4"
                              placeholder="option1&#10;option2&#10;option3"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">{{ old('options', $setting->options) }}</textarea>
                    <p class="mt-1 text-sm text-gray-500">Une option par ligne</p>
                </div>

                <!-- Description -->
                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                    <textarea name="description" 
                              id="description" 
                              rows="3"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror">{{ old('description', $setting->description) }}</textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Group -->
                <div>
                    <label for="group" class="block text-sm font-medium text-gray-700 mb-2">Groupe</label>
                    <select name="group" 
                            id="group" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('group') border-red-500 @enderror">
                        <option value="general" {{ old('group', $setting->group) == 'general' ? 'selected' : '' }}>Général</option>
                        <option value="site" {{ old('group', $setting->group) == 'site' ? 'selected' : '' }}>Site</option>
                        <option value="contact" {{ old('group', $setting->group) == 'contact' ? 'selected' : '' }}>Contact</option>
                        <option value="social" {{ old('group', $setting->group) == 'social' ? 'selected' : '' }}>Réseaux Sociaux</option>
                        <option value="seo" {{ old('group', $setting->group) == 'seo' ? 'selected' : '' }}>SEO</option>
                        <option value="mail" {{ old('group', $setting->group) == 'mail' ? 'selected' : '' }}>Email</option>
                        <option value="appearance" {{ old('group', $setting->group) == 'appearance' ? 'selected' : '' }}>Apparence</option>
                        <option value="security" {{ old('group', $setting->group) == 'security' ? 'selected' : '' }}>Sécurité</option>
                        <option value="api" {{ old('group', $setting->group) == 'api' ? 'selected' : '' }}>API</option>
                        <option value="advanced" {{ old('group', $setting->group) == 'advanced' ? 'selected' : '' }}>Avancé</option>
                    </select>
                    @error('group')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Order -->
                <div>
                    <label for="order" class="block text-sm font-medium text-gray-700 mb-2">Ordre d'Affichage</label>
                    <input type="number" 
                           name="order" 
                           id="order" 
                           value="{{ old('order', $setting->order) }}"
                           min="0"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('order') border-red-500 @enderror">
                    @error('order')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Options -->
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_required" 
                               id="is_required" 
                               value="1"
                               {{ old('is_required', $setting->is_required) ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_required" class="ml-2 text-sm text-gray-700">Requis</label>
                    </div>
                    
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_active" 
                               id="is_active" 
                               value="1"
                               {{ old('is_active', $setting->is_active) ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_active" class="ml-2 text-sm text-gray-700">Actif</label>
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="flex justify-end space-x-4 pt-6 border-t">
                    <a href="{{ route('admin.settings.index') }}" class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                        Annuler
                    </a>
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                        Mettre à Jour
                    </button>
                </div>
            </form>

            <!-- Delete Form -->
            <div class="mt-8 pt-8 border-t border-gray-200">
                <form action="{{ route('admin.settings.destroy', $setting) }}" method="POST" class="inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce paramètre ?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 text-white px-6 py-2 rounded-lg hover:bg-red-700 transition duration-300">
                        Supprimer le Paramètre
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function toggleValueFields() {
    const type = document.getElementById('type').value;
    const valueFields = document.querySelectorAll('.value-field');
    const optionsField = document.getElementById('options-field');
    
    // Hide all value fields
    valueFields.forEach(field => {
        field.style.display = 'none';
    });
    optionsField.style.display = 'none';
    
    // Show appropriate field based on type
    switch(type) {
        case 'textarea':
            document.getElementById('value-textarea').style.display = 'block';
            break;
        case 'json':
            document.getElementById('value-json').style.display = 'block';
            break;
        case 'file':
        case 'image':
            document.getElementById('value-file').style.display = 'block';
            break;
        case 'checkbox':
            document.getElementById('value-checkbox').style.display = 'block';
            break;
        case 'select':
            document.getElementById('value-text').style.display = 'block';
            optionsField.style.display = 'block';
            break;
        case 'text':
        case 'number':
        case 'email':
        case 'url':
        case 'tel':
        case 'color':
        case 'date':
        case 'time':
        default:
            document.getElementById('value-text').style.display = 'block';
            break;
    }
    
    // Update input type for value field
    const valueInput = document.getElementById('value');
    if (valueInput) {
        valueInput.type = ['text', 'textarea', 'select', 'checkbox', 'file', 'image', 'json'].includes(type) ? 'text' : type;
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleValueFields();
});
</script>
@endsection