@extends('layouts.admin')

@section('title', 'Créer un Paramètre')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Créer un Paramètre</h1>
            <a href="{{ route('admin.settings.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                Retour à la liste
            </a>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-2xl mx-auto">
            <form action="{{ route('admin.settings.store') }}" method="POST" class="space-y-6">
                @csrf
                
                <!-- Key -->
                <div>
                    <label for="key" class="block text-sm font-medium text-gray-700 mb-2">Clé *</label>
                    <input type="text" 
                           name="key" 
                           id="key" 
                           value="{{ old('key') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('key') border-red-500 @enderror"
                           required
                           pattern="[a-zA-Z0-9_.-]+"
                           placeholder="site_name, contact_email, etc.">
                    <p class="mt-1 text-sm text-gray-500">Utilisez uniquement des lettres, chiffres, points, tirets et underscores</p>
                    @error('key')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Value -->
                <div>
                    <label for="value" class="block text-sm font-medium text-gray-700 mb-2">Valeur *</label>
                    <div id="value-input-container">
                        <textarea name="value" 
                                  id="value" 
                                  rows="3"
                                  class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('value') border-red-500 @enderror"
                                  required>{{ old('value') }}</textarea>
                    </div>
                    @error('value')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Type -->
                <div>
                    <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                    <select name="type" 
                            id="type" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('type') border-red-500 @enderror"
                            required>
                        <option value="">Sélectionnez un type</option>
                        <option value="text" {{ old('type') == 'text' ? 'selected' : '' }}>Texte</option>
                        <option value="textarea" {{ old('type') == 'textarea' ? 'selected' : '' }}>Texte long</option>
                        <option value="number" {{ old('type') == 'number' ? 'selected' : '' }}>Nombre</option>
                        <option value="boolean" {{ old('type') == 'boolean' ? 'selected' : '' }}>Booléen (true/false)</option>
                        <option value="email" {{ old('type') == 'email' ? 'selected' : '' }}>Email</option>
                        <option value="url" {{ old('type') == 'url' ? 'selected' : '' }}>URL</option>
                        <option value="color" {{ old('type') == 'color' ? 'selected' : '' }}>Couleur</option>
                        <option value="json" {{ old('type') == 'json' ? 'selected' : '' }}>JSON</option>
                    </select>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Group -->
                <div>
                    <label for="group" class="block text-sm font-medium text-gray-700 mb-2">Groupe *</label>
                    <select name="group" 
                            id="group" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('group') border-red-500 @enderror"
                            required>
                        <option value="">Sélectionnez un groupe</option>
                        <option value="general" {{ old('group') == 'general' ? 'selected' : '' }}>Général</option>
                        <option value="contact" {{ old('group') == 'contact' ? 'selected' : '' }}>Contact</option>
                        <option value="social" {{ old('group') == 'social' ? 'selected' : '' }}>Réseaux Sociaux</option>
                        <option value="seo" {{ old('group') == 'seo' ? 'selected' : '' }}>SEO</option>
                        <option value="appearance" {{ old('group') == 'appearance' ? 'selected' : '' }}>Apparence</option>
                        <option value="mail" {{ old('group') == 'mail' ? 'selected' : '' }}>Email</option>
                        <option value="api" {{ old('group') == 'api' ? 'selected' : '' }}>API</option>
                        <option value="maintenance" {{ old('group') == 'maintenance' ? 'selected' : '' }}>Maintenance</option>
                    </select>
                    @error('group')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Label -->
                <div>
                    <label for="label" class="block text-sm font-medium text-gray-700 mb-2">Libellé</label>
                    <input type="text" 
                           name="label" 
                           id="label" 
                           value="{{ old('label') }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('label') border-red-500 @enderror"
                           placeholder="Nom du site, Email de contact, etc.">
                    <p class="mt-1 text-sm text-gray-500">Nom d'affichage du paramètre dans l'interface</p>
                    @error('label')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Description -->
                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                    <textarea name="description" 
                              id="description" 
                              rows="2"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror"
                              placeholder="Description de ce paramètre...">{{ old('description') }}</textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Order -->
                <div>
                    <label for="order" class="block text-sm font-medium text-gray-700 mb-2">Ordre d'affichage</label>
                    <input type="number" 
                           name="order" 
                           id="order" 
                           value="{{ old('order', 0) }}"
                           min="0"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('order') border-red-500 @enderror">
                    @error('order')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Options -->
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_public" 
                               id="is_public" 
                               value="1"
                               {{ old('is_public') ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_public" class="ml-2 text-sm text-gray-700">Paramètre public</label>
                        <span class="ml-2 text-xs text-gray-500">(accessible dans les vues)</span>
                    </div>
                    
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_editable" 
                               id="is_editable" 
                               value="1"
                               {{ old('is_editable', true) ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_editable" class="ml-2 text-sm text-gray-700">Paramètre modifiable</label>
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="flex justify-end space-x-4 pt-6 border-t">
                    <a href="{{ route('admin.settings.index') }}" class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                        Annuler
                    </a>
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                        Créer le Paramètre
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Dynamic value input based on type
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const container = document.getElementById('value-input-container');
    const currentValue = document.getElementById('value').value;
    
    let inputHtml = '';
    
    switch(type) {
        case 'text':
        case 'email':
        case 'url':
            inputHtml = `<input type="${type}" name="value" id="value" value="${currentValue}" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>`;
            break;
        case 'number':
            inputHtml = `<input type="number" name="value" id="value" value="${currentValue}" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>`;
            break;
        case 'boolean':
            const isTrue = currentValue === 'true' || currentValue === '1';
            inputHtml = `
                <select name="value" id="value" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>
                    <option value="true" ${isTrue ? 'selected' : ''}>True</option>
                    <option value="false" ${!isTrue ? 'selected' : ''}>False</option>
                </select>`;
            break;
        case 'color':
            inputHtml = `<input type="color" name="value" id="value" value="${currentValue || '#000000'}" class="w-full h-10 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>`;
            break;
        case 'textarea':
        case 'json':
        default:
            const rows = type === 'json' ? 6 : 3;
            inputHtml = `<textarea name="value" id="value" rows="${rows}" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" required>${currentValue}</textarea>`;
            break;
    }
    
    container.innerHTML = inputHtml;
});

// Auto-generate label from key
document.getElementById('key').addEventListener('input', function() {
    const key = this.value;
    const labelField = document.getElementById('label');
    if (!labelField.value) {
        // Convert snake_case to Title Case
        const label = key.replace(/_/g, ' ')
                        .replace(/\b\w/g, l => l.toUpperCase());
        labelField.value = label;
    }
});
</script>
@endsection