@extends('layouts.admin')

@section('title', 'Détails de la Page')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Détails de la Page</h1>
            <div class="flex space-x-3">
                @if($page->status == 'published')
                    <a href="{{ url('/' . $page->slug) }}" 
                       target="_blank"
                       class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition duration-300">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                        </svg>
                        Voir la page
                    </a>
                @endif
                <a href="{{ route('admin.pages.edit', $page) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Modifier
                </a>
                <a href="{{ route('admin.pages.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                    Retour à la liste
                </a>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-6xl mx-auto">
            <div class="bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                <!-- Header -->
                <div class="bg-gray-50 px-6 py-4 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <div>
                            <h2 class="text-2xl font-bold text-gray-900">{{ $page->title }}</h2>
                            <p class="text-gray-600 mt-1">
                                <span class="font-medium">Slug:</span> 
                                <code class="bg-gray-100 px-2 py-1 rounded text-sm">{{ $page->slug }}</code>
                            </p>
                        </div>
                        <div class="flex items-center space-x-3">
                            <!-- Status Badge -->
                            @if($page->status == 'published')
                                <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-medium">
                                    <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    Publié
                                </span>
                            @elseif($page->status == 'draft')
                                <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-medium">
                                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>
                                    </svg>
                                    Brouillon
                                </span>
                            @else
                                <span class="bg-gray-100 text-gray-800 px-3 py-1 rounded-full text-sm font-medium">
                                    {{ ucfirst($page->status) }}
                                </span>
                            @endif

                            @if($page->show_in_menu)
                                <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
                                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                                    </svg>
                                    Dans le menu
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="p-6">
                    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                        <!-- Left Column - Main Content -->
                        <div class="lg:col-span-2 space-y-6">
                            <!-- Featured Image -->
                            @if($page->featured_image)
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Image à la une</h3>
                                    <img src="{{ asset('storage/' . $page->featured_image) }}" 
                                         alt="{{ $page->title }}" 
                                         class="w-full h-64 object-cover rounded-lg border">
                                </div>
                            @endif

                            <!-- Excerpt -->
                            @if($page->excerpt)
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Extrait</h3>
                                    <div class="prose prose-sm text-gray-600 bg-gray-50 p-4 rounded-lg border">
                                        {!! nl2br(e($page->excerpt)) !!}
                                    </div>
                                </div>
                            @endif

                            <!-- Content -->
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-3">Contenu</h3>
                                <div class="prose max-w-none text-gray-700 bg-gray-50 p-6 rounded-lg border">
                                    {!! nl2br(e($page->content)) !!}
                                </div>
                            </div>

                            <!-- Custom Fields -->
                            @if($page->custom_fields && count($page->custom_fields) > 0)
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Champs personnalisés</h3>
                                    <div class="bg-gray-50 p-4 rounded-lg border">
                                        @foreach($page->custom_fields as $key => $value)
                                            <div class="flex justify-between items-center py-2 border-b border-gray-200 last:border-b-0">
                                                <span class="font-medium text-gray-700">{{ $key }}:</span>
                                                <span class="text-gray-900">{{ $value }}</span>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>

                        <!-- Right Column - Sidebar -->
                        <div class="space-y-6">
                            <!-- Page Settings -->
                            <div class="bg-gray-50 p-4 rounded-lg border">
                                <h3 class="text-lg font-semibold text-gray-900 mb-3">Paramètres</h3>
                                <div class="space-y-3 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Template:</span>
                                        <span class="text-gray-900 font-medium">{{ $page->template ?: 'default' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Ordre:</span>
                                        <span class="text-gray-900 font-medium">{{ $page->order ?: 0 }}</span>
                                    </div>
                                    @if($page->menu_title)
                                        <div class="flex justify-between">
                                            <span class="text-gray-600">Titre du menu:</span>
                                            <span class="text-gray-900 font-medium">{{ $page->menu_title }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Hierarchy -->
                            @if($page->parent_id || $page->children->count() > 0)
                                <div class="bg-gray-50 p-4 rounded-lg border">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Hiérarchie</h3>
                                    
                                    @if($page->parent_id)
                                        <div class="mb-3">
                                            <span class="text-gray-600 text-sm">Page parente:</span>
                                            <div class="mt-1">
                                                <a href="{{ route('admin.pages.show', $page->parent) }}" 
                                                   class="text-blue-600 hover:text-blue-800 font-medium">
                                                    {{ $page->parent->title }}
                                                </a>
                                            </div>
                                        </div>
                                    @endif

                                    @if($page->children->count() > 0)
                                        <div>
                                            <span class="text-gray-600 text-sm">Pages enfants ({{ $page->children->count() }}):</span>
                                            <div class="mt-2 space-y-1">
                                                @foreach($page->children as $child)
                                                    <div class="flex items-center justify-between text-sm">
                                                        <a href="{{ route('admin.pages.show', $child) }}" 
                                                           class="text-blue-600 hover:text-blue-800">
                                                            {{ $child->title }}
                                                        </a>
                                                        <span class="px-2 py-1 text-xs rounded {{ $child->status == 'published' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                                            {{ $child->status }}
                                                        </span>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif

                            <!-- SEO Metadata -->
                            @if($page->meta && count($page->meta) > 0)
                                <div class="bg-gray-50 p-4 rounded-lg border">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-3">
                                        <svg class="w-5 h-5 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                        </svg>
                                        SEO
                                    </h3>
                                    <div class="space-y-3 text-sm">
                                        @foreach($page->meta as $key => $value)
                                            <div>
                                                <span class="text-gray-600 font-medium">{{ ucfirst(str_replace('_', ' ', $key)) }}:</span>
                                                <p class="text-gray-900 mt-1">{{ $value }}</p>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <!-- Dates -->
                            <div class="bg-gray-50 p-4 rounded-lg border">
                                <h3 class="text-lg font-semibold text-gray-900 mb-3">Dates</h3>
                                <div class="space-y-2 text-sm">
                                    <div>
                                        <span class="text-gray-600">Créé:</span>
                                        <p class="text-gray-900">{{ $page->created_at->format('d/m/Y à H:i') }}</p>
                                    </div>
                                    <div>
                                        <span class="text-gray-600">Modifié:</span>
                                        <p class="text-gray-900">{{ $page->updated_at->format('d/m/Y à H:i') }}</p>
                                    </div>
                                    @if($page->published_at)
                                        <div>
                                            <span class="text-gray-600">Publié:</span>
                                            <p class="text-gray-900">{{ $page->published_at->format('d/m/Y à H:i') }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    <div class="flex justify-between">
                        <form action="{{ route('admin.pages.destroy', $page) }}" 
                              method="POST" 
                              onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette page ?{{ $page->children->count() > 0 ? ' Attention: cette page a ' . $page->children->count() . ' page(s) enfant(s) qui seront aussi supprimées.' : '' }}')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition duration-300">
                                Supprimer cette page
                            </button>
                        </form>

                        <div class="flex space-x-3">
                            @if($page->status == 'published')
                                <a href="{{ url('/' . $page->slug) }}" 
                                   target="_blank"
                                   class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition duration-300">
                                    Voir la page
                                </a>
                            @endif
                            <a href="{{ route('admin.pages.edit', $page) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                                Modifier
                            </a>
                            <a href="{{ route('admin.pages.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                                Retour à la liste
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection