@extends('layouts.admin')

@section('title', 'Gestion des Pages')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Gestion des Pages</h1>
            <a href="{{ route('admin.pages.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouvelle Page
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white border-b border-gray-200 px-6 py-4">
        <form method="GET" class="flex flex-wrap gap-4 items-end">
            <!-- Search -->
            <div class="flex-1 min-w-64">
                <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Rechercher</label>
                <input type="text" 
                       name="search" 
                       id="search" 
                       value="{{ request('search') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                       placeholder="Titre ou contenu de la page...">
            </div>

            <!-- Status Filter -->
            <div class="min-w-48">
                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Statut</label>
                <select name="status" 
                        id="status" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Tous les statuts</option>
                    @foreach($statuses as $status)
                        <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                            {{ ucfirst($status) }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Actions -->
            <div class="flex space-x-2">
                <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition duration-300">
                    Filtrer
                </button>
                <a href="{{ route('admin.pages.index') }}" class="bg-gray-400 text-white px-4 py-2 rounded-lg hover:bg-gray-500 transition duration-300">
                    Réinitialiser
                </a>
            </div>
        </form>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <!-- Success Message -->
        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        <!-- Error Message -->
        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                {{ session('error') }}
            </div>
        @endif

        <!-- Pages List -->
        @if($pages->count() > 0)
            <div class="space-y-4">
                @foreach($pages as $page)
                    <div class="bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden hover:shadow-lg transition duration-300">
                        <div class="p-6">
                            <!-- Header -->
                            <div class="flex items-start justify-between mb-4">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-3 mb-2">
                                        <!-- Status Badge -->
                                        @if($page->status == 'published')
                                            <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-medium">
                                                <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                                </svg>
                                                Publié
                                            </span>
                                        @elseif($page->status == 'draft')
                                            <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-medium">
                                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>
                                                </svg>
                                                Brouillon
                                            </span>
                                        @else
                                            <span class="bg-gray-100 text-gray-800 px-3 py-1 rounded-full text-sm font-medium">
                                                {{ ucfirst($page->status) }}
                                            </span>
                                        @endif

                                        <!-- Menu Badge -->
                                        @if($page->show_in_menu)
                                            <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
                                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                                                </svg>
                                                Menu
                                            </span>
                                        @endif

                                        <!-- Template Badge -->
                                        @if($page->template && $page->template !== 'default')
                                            <span class="bg-purple-100 text-purple-800 px-3 py-1 rounded-full text-sm font-medium">
                                                {{ ucfirst($page->template) }}
                                            </span>
                                        @endif
                                    </div>

                                    <h3 class="font-semibold text-lg text-gray-900 mb-2">{{ $page->title }}</h3>
                                    <p class="text-gray-600 text-sm mb-1">
                                        <span class="font-medium">Slug:</span> 
                                        <code class="bg-gray-100 px-1 rounded">{{ $page->slug }}</code>
                                    </p>
                                </div>

                                <div class="flex items-center space-x-2 ml-4">
                                    <!-- Order -->
                                    <span class="text-sm text-gray-500 bg-gray-100 px-2 py-1 rounded">
                                        #{{ $page->order ?? 0 }}
                                    </span>
                                </div>
                            </div>

                            <!-- Featured Image -->
                            @if($page->featured_image)
                                <div class="mb-4">
                                    <img src="{{ asset('storage/' . $page->featured_image) }}" 
                                         alt="{{ $page->title }}" 
                                         class="w-full h-32 object-cover rounded-lg">
                                </div>
                            @endif

                            <!-- Excerpt/Content Preview -->
                            @if($page->excerpt)
                                <div class="mb-4">
                                    <p class="text-gray-600 text-sm">{{ Str::limit($page->excerpt, 150) }}</p>
                                </div>
                            @else
                                <div class="mb-4">
                                    <p class="text-gray-600 text-sm">{{ Str::limit(strip_tags($page->content), 150) }}</p>
                                </div>
                            @endif

                            <!-- Hierarchy Info -->
                            @if($page->parent_id)
                                <div class="mb-4 text-sm text-gray-500">
                                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                    </svg>
                                    Page enfant de: <strong>{{ $page->parent->title ?? 'Page supprimée' }}</strong>
                                </div>
                            @endif

                            <!-- Children Info -->
                            @if($page->children && $page->children->count() > 0)
                                <div class="mb-4 text-sm text-gray-500">
                                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                                    </svg>
                                    {{ $page->children->count() }} page(s) enfant(s)
                                </div>
                            @endif

                            <!-- Actions -->
                            <div class="flex justify-between items-center pt-4 border-t border-gray-200">
                                <div class="text-xs text-gray-500">
                                    Créé le {{ $page->created_at->format('d/m/Y à H:i') }}
                                    @if($page->published_at)
                                        • Publié le {{ $page->published_at->format('d/m/Y à H:i') }}
                                    @endif
                                    @if($page->created_at != $page->updated_at)
                                        • Modifié le {{ $page->updated_at->format('d/m/Y à H:i') }}
                                    @endif
                                </div>
                                <div class="flex space-x-2">
                                    @if($page->status == 'published')
                                        <a href="{{ url('/' . $page->slug) }}" 
                                           target="_blank"
                                           class="text-green-600 hover:text-green-800 text-sm font-medium">
                                            <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                                            </svg>
                                            Voir
                                        </a>
                                    @endif
                                    <a href="{{ route('admin.pages.show', $page) }}" 
                                       class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                        Détails
                                    </a>
                                    <a href="{{ route('admin.pages.edit', $page) }}" 
                                       class="text-yellow-600 hover:text-yellow-800 text-sm font-medium">
                                        Modifier
                                    </a>
                                    <form action="{{ route('admin.pages.destroy', $page) }}" 
                                          method="POST" 
                                          class="inline"
                                          onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette page ?{{ $page->children->count() > 0 ? ' Attention: cette page a des pages enfants qui seront aussi supprimées.' : '' }}')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium">
                                            Supprimer
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-6">
                {{ $pages->appends(request()->query())->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h3 class="text-xl font-medium text-gray-900 mb-2">Aucune page trouvée</h3>
                <p class="text-gray-500 mb-4">
                    @if(request()->hasAny(['search', 'status']))
                        Aucune page ne correspond à vos critères de recherche.
                    @else
                        Commencez par créer votre première page.
                    @endif
                </p>
                <a href="{{ route('admin.pages.create') }}" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Créer une Page
                </a>
            </div>
        @endif
    </div>
</div>
@endsection