@extends('layouts.admin')

@section('title', 'Galerie d\'Images')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Galerie d'Images</h1>
            <a href="{{ route('admin.galleries.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                Ajouter une Image
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white border-b border-gray-200 px-6 py-4">
        <form action="{{ route('admin.galleries.index') }}" method="GET" class="flex flex-wrap gap-4">
            <div class="flex-1 min-w-64">
                <input type="text" 
                       name="search" 
                       value="{{ request('search') }}"
                       placeholder="Rechercher par titre ou description..."
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <select name="category" class="px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Toutes les catégories</option>
                    <option value="events" {{ request('category') == 'events' ? 'selected' : '' }}>Événements</option>
                    <option value="projects" {{ request('category') == 'projects' ? 'selected' : '' }}>Projets</option>
                    <option value="training" {{ request('category') == 'training' ? 'selected' : '' }}>Formations</option>
                    <option value="community" {{ request('category') == 'community' ? 'selected' : '' }}>Communauté</option>
                    <option value="partnerships" {{ request('category') == 'partnerships' ? 'selected' : '' }}>Partenariats</option>
                    <option value="general" {{ request('category') == 'general' ? 'selected' : '' }}>Général</option>
                </select>
            </div>
            <div>
                <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition duration-300">
                    Filtrer
                </button>
            </div>
            @if(request()->hasAny(['search', 'category']))
                <div>
                    <a href="{{ route('admin.galleries.index') }}" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 transition duration-300">
                        Réinitialiser
                    </a>
                </div>
            @endif
        </form>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        @if($galleries->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                @foreach($galleries as $gallery)
                    <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                        <!-- Image -->
                        <div class="aspect-w-16 aspect-h-9 bg-gray-200">
                            @if($gallery->image_path)
                                <img src="{{ asset('storage/' . $gallery->image_path) }}" 
                                     alt="{{ $gallery->title }}" 
                                     class="w-full h-48 object-cover">
                            @else
                                <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                                    <svg class="w-12 h-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                            @endif
                        </div>

                        <!-- Content -->
                        <div class="p-4">
                            <div class="flex items-start justify-between mb-2">
                                <h3 class="font-semibold text-gray-900 line-clamp-2">{{ $gallery->title }}</h3>
                                @if($gallery->is_featured)
                                    <span class="inline-block bg-yellow-100 text-yellow-800 text-xs px-2 py-1 rounded-full ml-2 flex-shrink-0">
                                        Mise en avant
                                    </span>
                                @endif
                            </div>

                            @if($gallery->description)
                                <p class="text-sm text-gray-600 mb-3 line-clamp-2">{{ Str::limit($gallery->description, 100) }}</p>
                            @endif

                            <div class="flex items-center justify-between text-sm text-gray-500 mb-3">
                                @if($gallery->category)
                                    <span class="bg-gray-100 text-gray-800 px-2 py-1 rounded-full">
                                        {{ match($gallery->category) {
                                            'events' => 'Événements',
                                            'projects' => 'Projets',
                                            'training' => 'Formations',
                                            'community' => 'Communauté',
                                            'partnerships' => 'Partenariats',
                                            'general' => 'Général',
                                            default => $gallery->category
                                        } }}
                                    </span>
                                @endif
                                <span>Ordre: {{ $gallery->order }}</span>
                            </div>

                            <div class="flex items-center justify-between">
                                <div class="text-xs text-gray-400">
                                    {{ $gallery->created_at->format('d/m/Y') }}
                                </div>
                                <div class="flex space-x-2">
                                    <a href="{{ route('admin.galleries.edit', $gallery) }}" 
                                       class="text-blue-600 hover:text-blue-800 transition-colors duration-200">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                        </svg>
                                    </a>
                                    <form action="{{ route('admin.galleries.destroy', $gallery) }}" 
                                          method="POST" 
                                          class="inline"
                                          onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette image ?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-800 transition-colors duration-200">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-8">
                {{ $galleries->withQueryString()->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                </svg>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucune image trouvée</h3>
                <p class="text-gray-500 mb-6">Commencez par ajouter votre première image à la galerie.</p>
                <a href="{{ route('admin.galleries.create') }}" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition duration-300">
                    Ajouter une Image
                </a>
            </div>
        @endif
    </div>
</div>
@endsection