@extends('layouts.admin')

@section('title', 'Gestion des FAQ')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Gestion des FAQ</h1>
            <a href="{{ route('admin.faqs.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                Nouvelle FAQ
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white border-b border-gray-200 px-6 py-4">
        <form method="GET" class="flex flex-wrap gap-4 items-end">
            <!-- Search -->
            <div class="flex-1 min-w-64">
                <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Rechercher</label>
                <input type="text" 
                       name="search" 
                       id="search" 
                       value="{{ request('search') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                       placeholder="Question ou réponse...">
            </div>

            <!-- Category Filter -->
            <div class="min-w-48">
                <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Catégorie</label>
                <select name="category" 
                        id="category" 
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                    <option value="">Toutes les catégories</option>
                    @foreach($categories as $category)
                        <option value="{{ $category }}" {{ request('category') == $category ? 'selected' : '' }}>
                            {{ ucfirst($category) }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- Actions -->
            <div class="flex space-x-2">
                <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition duration-300">
                    Filtrer
                </button>
                <a href="{{ route('admin.faqs.index') }}" class="bg-gray-400 text-white px-4 py-2 rounded-lg hover:bg-gray-500 transition duration-300">
                    Réinitialiser
                </a>
            </div>
        </form>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <!-- Success Message -->
        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('success') }}
            </div>
        @endif

        <!-- Error Message -->
        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                {{ session('error') }}
            </div>
        @endif

        <!-- FAQs List -->
        @if($faqs->count() > 0)
            <div class="space-y-4">
                @foreach($faqs as $faq)
                    <div class="bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden hover:shadow-lg transition duration-300">
                        <div class="p-6">
                            <!-- Header -->
                            <div class="flex items-start justify-between mb-4">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-3 mb-2">
                                        <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-medium">
                                            {{ ucfirst($faq->category) }}
                                        </span>
                                        @if($faq->is_featured ?? false)
                                            <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-medium">
                                                <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                                </svg>
                                                Vedette
                                            </span>
                                        @endif
                                        @if($faq->is_published ?? true)
                                            <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-medium">
                                                Publié
                                            </span>
                                        @else
                                            <span class="bg-red-100 text-red-800 px-3 py-1 rounded-full text-sm font-medium">
                                                Brouillon
                                            </span>
                                        @endif
                                    </div>
                                    <h3 class="font-semibold text-lg text-gray-900 mb-2">{{ $faq->question }}</h3>
                                </div>
                                <div class="flex items-center space-x-2 ml-4">
                                    <!-- Order -->
                                    <span class="text-sm text-gray-500 bg-gray-100 px-2 py-1 rounded">
                                        Ordre: {{ $faq->order ?? 0 }}
                                    </span>
                                </div>
                            </div>

                            <!-- Answer Preview -->
                            <div class="mb-4">
                                <div class="prose prose-sm text-gray-600 max-w-none">
                                    {!! Str::limit(strip_tags($faq->answer), 200) !!}
                                </div>
                            </div>

                            <!-- Stats -->
                            @if($faq->views ?? false)
                                <div class="text-sm text-gray-500 mb-4">
                                    <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    {{ $faq->views }} vue(s)
                                </div>
                            @endif

                            <!-- Keywords -->
                            @if($faq->keywords && count($faq->keywords) > 0)
                                <div class="flex flex-wrap gap-1 mb-4">
                                    @foreach($faq->keywords as $keyword)
                                        <span class="bg-gray-100 text-gray-700 px-2 py-1 rounded text-xs">
                                            {{ $keyword }}
                                        </span>
                                    @endforeach
                                </div>
                            @endif

                            <!-- Actions -->
                            <div class="flex justify-between items-center pt-4 border-t border-gray-200">
                                <div class="text-xs text-gray-500">
                                    Créé le {{ $faq->created_at->format('d/m/Y à H:i') }}
                                    @if($faq->created_at != $faq->updated_at)
                                        • Modifié le {{ $faq->updated_at->format('d/m/Y à H:i') }}
                                    @endif
                                </div>
                                <div class="flex space-x-2">
                                    <a href="{{ route('admin.faqs.show', $faq) }}" 
                                       class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                        Voir
                                    </a>
                                    <a href="{{ route('admin.faqs.edit', $faq) }}" 
                                       class="text-green-600 hover:text-green-800 text-sm font-medium">
                                        Modifier
                                    </a>
                                    <form action="{{ route('admin.faqs.destroy', $faq) }}" 
                                          method="POST" 
                                          class="inline"
                                          onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette FAQ ?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium">
                                            Supprimer
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-6">
                {{ $faqs->appends(request()->query())->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <h3 class="text-xl font-medium text-gray-900 mb-2">Aucune FAQ trouvée</h3>
                <p class="text-gray-500 mb-4">
                    @if(request()->hasAny(['search', 'category']))
                        Aucune FAQ ne correspond à vos critères de recherche.
                    @else
                        Commencez par créer votre première FAQ.
                    @endif
                </p>
                <a href="{{ route('admin.faqs.create') }}" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Créer une FAQ
                </a>
            </div>
        @endif
    </div>
</div>
@endsection