@extends('layouts.admin')

@section('title', 'Détails du Document')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">{{ $document->title }}</h1>
            <div class="flex space-x-2">
                <a href="{{ route('admin.documents.edit', $document) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Modifier
                </a>
                <a href="{{ route('admin.documents.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                    Retour à la liste
                </a>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-4xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Content -->
                <div class="lg:col-span-2">
                    <div class="bg-white shadow rounded-lg p-6">
                        <!-- Document Info -->
                        <div class="mb-6">
                            @if($document->description)
                                <div class="mb-4">
                                    <h3 class="text-lg font-medium text-gray-900 mb-2">Description</h3>
                                    <p class="text-gray-700">{{ $document->description }}</p>
                                </div>
                            @endif

                            <!-- File Preview/Download -->
                            <div class="border-2 border-dashed border-gray-300 rounded-lg p-8 text-center">
                                @php
                                    $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));
                                    $iconClass = match($extension) {
                                        'pdf' => 'text-red-500',
                                        'doc', 'docx' => 'text-blue-500',
                                        'xls', 'xlsx' => 'text-green-500',
                                        'ppt', 'pptx' => 'text-orange-500',
                                        'jpg', 'jpeg', 'png', 'gif' => 'text-purple-500',
                                        default => 'text-gray-500'
                                    };
                                @endphp
                                <svg class="mx-auto h-16 w-16 {{ $iconClass }}" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd" />
                                </svg>
                                <h3 class="mt-4 text-lg font-medium text-gray-900">{{ basename($document->file_path) }}</h3>
                                <p class="mt-2 text-sm text-gray-500">
                                    {{ strtoupper($extension) }} 
                                    @if($document->file_size)
                                        - {{ number_format($document->file_size / 1024, 0) }} KB
                                    @endif
                                </p>
                                <div class="mt-6 flex justify-center space-x-4">
                                    <a href="{{ asset('storage/' . $document->file_path) }}" 
                                       target="_blank"
                                       class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                        </svg>
                                        Ouvrir
                                    </a>
                                    <a href="{{ asset('storage/' . $document->file_path) }}" 
                                       download
                                       class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 transition duration-300">
                                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        Télécharger
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="lg:col-span-1">
                    <!-- Document Details -->
                    <div class="bg-white shadow rounded-lg p-6 mb-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Détails</h3>
                        <dl class="space-y-3">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Catégorie</dt>
                                <dd class="mt-1">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        {{ match($document->category) {
                                            'rapport' => 'bg-blue-100 text-blue-800',
                                            'procedure' => 'bg-green-100 text-green-800',
                                            'formulaire' => 'bg-yellow-100 text-yellow-800',
                                            'guide' => 'bg-purple-100 text-purple-800',
                                            'presentation' => 'bg-pink-100 text-pink-800',
                                            default => 'bg-gray-100 text-gray-800'
                                        } }}">
                                        {{ match($document->category) {
                                            'rapport' => 'Rapport',
                                            'procedure' => 'Procédure',
                                            'formulaire' => 'Formulaire',
                                            'guide' => 'Guide',
                                            'presentation' => 'Présentation',
                                            default => 'Autre'
                                        } }}
                                    </span>
                                </dd>
                            </div>

                            @if($document->version)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Version</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $document->version }}</dd>
                                </div>
                            @endif

                            <div>
                                <dt class="text-sm font-medium text-gray-500">Niveau d'accès</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    @if($document->is_public)
                                        <span class="text-green-600">Public</span>
                                    @else
                                        <span class="text-red-600">Privé</span>
                                    @endif
                                </dd>
                            </div>

                            <div>
                                <dt class="text-sm font-medium text-gray-500">Téléchargements</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $document->download_count ?? 0 }}</dd>
                            </div>

                            <div>
                                <dt class="text-sm font-medium text-gray-500">Créé le</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $document->created_at->format('d/m/Y à H:i') }}</dd>
                            </div>

                            @if($document->updated_at != $document->created_at)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Modifié le</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $document->updated_at->format('d/m/Y à H:i') }}</dd>
                                </div>
                            @endif
                        </dl>
                    </div>

                    <!-- Status Badges -->
                    <div class="bg-white shadow rounded-lg p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Statut</h3>
                        <div class="space-y-2">
                            @if($document->is_featured)
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                    Mis en avant
                                </span>
                            @endif



                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                                Actif
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection