@extends('layouts.admin')

@section('title', 'Modifier le Document')

@se                                    <p class="text-sm font-medium text-gray-900">{{ basename($document->file_path) }}</p>
                                    <p class="text-xs text-gray-500">
                                        @if($document->file_size)
                                            {{ number_format($document->file_size / 1024, 0) }} KB
                                        @endif
                                    </p>
                                    <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank" class="text-blue-600 hover:text-blue-800 text-sm">('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Modifier le Document</h1>
            <a href="{{ route('admin.documents.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                Retour à la liste
            </a>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-2xl mx-auto">
            <form action="{{ route('admin.documents.update', $document) }}" method="POST" enctype="multipart/form-data" class="space-y-6">
                @csrf
                @method('PUT')
                
                <!-- Title -->
                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700 mb-2">Titre *</label>
                    <input type="text" 
                           name="title" 
                           id="title" 
                           value="{{ old('title', $document->title) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('title') border-red-500 @enderror"
                           required>
                    @error('title')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Slug -->
                <div>
                    <label for="slug" class="block text-sm font-medium text-gray-700 mb-2">Slug *</label>
                    <input type="text" 
                           name="slug" 
                           id="slug" 
                           value="{{ old('slug', $document->slug) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('slug') border-red-500 @enderror"
                           required>
                    @error('slug')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Description -->
                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                    <textarea name="description" 
                              id="description" 
                              rows="4"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('description') border-red-500 @enderror">{{ old('description', $document->description) }}</textarea>
                    @error('description')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- File Upload -->
                <div>
                    <label for="file" class="block text-sm font-medium text-gray-700 mb-2">Fichier</label>
                    @if($document->file_path)
                        <div class="mb-4 p-4 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <svg class="w-8 h-8 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <div>
                                    <p class="text-sm font-medium text-gray-900">{{ basename($document->file_path) }}</p>
                                    <p class="text-sm text-gray-500">
                                        Taille: {{ formatBytes(file_exists(storage_path('app/public/' . $document->file_path)) ? filesize(storage_path('app/public/' . $document->file_path)) : 0) }}
                                    </p>
                                    <a href="{{ image_url($document->file_path) }}" target="_blank" class="text-blue-600 hover:text-blue-800 text-sm">
                                        Télécharger le fichier actuel
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endif
                    <input type="file" 
                           name="file" 
                           id="file" 
                           accept=".pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.txt"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('file') border-red-500 @enderror">
                    <p class="mt-1 text-sm text-gray-500">Formats acceptés: PDF, DOC, DOCX, XLS, XLSX, PPT, PPTX, TXT (Max: 10MB)</p>
                    @error('file')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Type -->
                <div>
                    <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type de Document</label>
                    <select name="type" 
                            id="type" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('type') border-red-500 @enderror">
                        <option value="">Sélectionnez un type</option>
                        <option value="rapport" {{ old('type', $document->type) == 'rapport' ? 'selected' : '' }}>Rapport</option>
                        <option value="presentation" {{ old('type', $document->type) == 'presentation' ? 'selected' : '' }}>Présentation</option>
                        <option value="formulaire" {{ old('type', $document->type) == 'formulaire' ? 'selected' : '' }}>Formulaire</option>
                        <option value="guide" {{ old('type', $document->type) == 'guide' ? 'selected' : '' }}>Guide</option>
                        <option value="manuel" {{ old('type', $document->type) == 'manuel' ? 'selected' : '' }}>Manuel</option>
                        <option value="politique" {{ old('type', $document->type) == 'politique' ? 'selected' : '' }}>Politique</option>
                        <option value="procedure" {{ old('type', $document->type) == 'procedure' ? 'selected' : '' }}>Procédure</option>
                        <option value="legal" {{ old('type', $document->type) == 'legal' ? 'selected' : '' }}>Document Légal</option>
                        <option value="autre" {{ old('type', $document->type) == 'autre' ? 'selected' : '' }}>Autre</option>
                    </select>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Category -->
                <div>
                    <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Catégorie</label>
                    <select name="category" 
                            id="category" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('category') border-red-500 @enderror">
                        <option value="">Sélectionnez une catégorie</option>
                        <option value="administration" {{ old('category', $document->category) == 'administration' ? 'selected' : '' }}>Administration</option>
                        <option value="programmes" {{ old('category', $document->category) == 'programmes' ? 'selected' : '' }}>Programmes</option>
                        <option value="financier" {{ old('category', $document->category) == 'financier' ? 'selected' : '' }}>Financier</option>
                        <option value="juridique" {{ old('category', $document->category) == 'juridique' ? 'selected' : '' }}>Juridique</option>
                        <option value="communication" {{ old('category', $document->category) == 'communication' ? 'selected' : '' }}>Communication</option>
                        <option value="formation" {{ old('category', $document->category) == 'formation' ? 'selected' : '' }}>Formation</option>
                        <option value="ressources" {{ old('category', $document->category) == 'ressources' ? 'selected' : '' }}>Ressources</option>
                        <option value="autre" {{ old('category', $document->category) == 'autre' ? 'selected' : '' }}>Autre</option>
                    </select>
                    @error('category')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Version -->
                <div>
                    <label for="version" class="block text-sm font-medium text-gray-700 mb-2">Version</label>
                    <input type="text" 
                           name="version" 
                           id="version" 
                           value="{{ old('version', $document->version) }}"
                           placeholder="1.0"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('version') border-red-500 @enderror">
                    @error('version')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Language -->
                <div>
                    <label for="language" class="block text-sm font-medium text-gray-700 mb-2">Langue</label>
                    <select name="language" 
                            id="language" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('language') border-red-500 @enderror">
                        <option value="fr" {{ old('language', $document->language) == 'fr' ? 'selected' : '' }}>Français</option>
                        <option value="en" {{ old('language', $document->language) == 'en' ? 'selected' : '' }}>Anglais</option>
                        <option value="ln" {{ old('language', $document->language) == 'ln' ? 'selected' : '' }}>Lingala</option>
                        <option value="kg" {{ old('language', $document->language) == 'kg' ? 'selected' : '' }}>Kikongo</option>
                    </select>
                    @error('language')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Tags -->
                <div>
                    <label for="tags" class="block text-sm font-medium text-gray-700 mb-2">Tags</label>
                    <input type="text" 
                           name="tags" 
                           id="tags" 
                           value="{{ old('tags', $document->tags) }}"
                           placeholder="Séparez les tags par des virgules"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 @error('tags') border-red-500 @enderror">
                    <p class="mt-1 text-sm text-gray-500">Exemple: rapport, annual, 2024</p>
                    @error('tags')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Options -->
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_public" 
                               id="is_public" 
                               value="1"
                               {{ old('is_public', $document->is_public) ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_public" class="ml-2 text-sm text-gray-700">Document public</label>
                    </div>
                    
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_featured" 
                               id="is_featured" 
                               value="1"
                               {{ old('is_featured', $document->is_featured) ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_featured" class="ml-2 text-sm text-gray-700">Mettre en avant</label>
                    </div>
                    
                    <div class="flex items-center">
                        <input type="checkbox" 
                               name="is_active" 
                               id="is_active" 
                               value="1"
                               {{ old('is_active', $document->is_active) ? 'checked' : '' }}
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                        <label for="is_active" class="ml-2 text-sm text-gray-700">Actif</label>
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="flex justify-end space-x-4 pt-6 border-t">
                    <a href="{{ route('admin.documents.index') }}" class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                        Annuler
                    </a>
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                        Mettre à Jour
                    </button>
                </div>
            </form>

            <!-- Delete Form -->
            <div class="mt-8 pt-8 border-t border-gray-200">
                <form action="{{ route('admin.documents.destroy', $document) }}" method="POST" class="inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer ce document ?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 text-white px-6 py-2 rounded-lg hover:bg-red-700 transition duration-300">
                        Supprimer le Document
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('title').addEventListener('input', function() {
    const title = this.value;
    const slug = title.toLowerCase()
        .replace(/[^a-z0-9]+/g, '-')
        .replace(/(^-|-$)+/g, '');
    document.getElementById('slug').value = slug;
});

// Helper function for file size formatting
function formatBytes(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}
</script>
@endsection

@php
function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    
    for ($i = 0; $bytes > 1024; $i++) {
        $bytes /= 1024;
    }
    
    return round($bytes, $precision) . ' ' . $units[$i];
}
@endphp