@extends('layouts.admin')

@section('title', 'Détails de l\'Article')

@section('content')
<div class="flex-1 flex flex-col overflow-hidden">
    <!-- Header -->
    <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-semibold text-gray-900">Détails de l'Article</h1>
            <div class="flex space-x-2">
                <a href="{{ route('article', $article->slug) }}" target="_blank" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition duration-300">
                    Voir sur le Site
                </a>
                <a href="{{ route('admin.articles.edit', $article) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                    Modifier
                </a>
                <a href="{{ route('admin.articles.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-300">
                    Retour à la liste
                </a>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6">
        <div class="max-w-4xl mx-auto space-y-6">
            
            <!-- Article Status Card -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-semibold">Informations de l'Article</h2>
                    <div class="flex space-x-2">
                        @if($article->status === 'published')
                            <span class="bg-green-100 text-green-800 px-3 py-1 rounded-full text-sm font-semibold">Publié</span>
                        @else
                            <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-semibold">Brouillon</span>
                        @endif
                        
                        @if($article->is_featured)
                            <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm font-semibold">À la Une</span>
                        @endif
                        
                        <span class="bg-gray-100 text-gray-800 px-3 py-1 rounded-full text-sm font-semibold">{{ ucfirst($article->category) }}</span>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Titre</h3>
                        <p class="text-lg font-semibold text-gray-900">{{ $article->title }}</p>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Slug</h3>
                        <p class="text-gray-900">{{ $article->slug }}</p>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Auteur</h3>
                        <p class="text-gray-900">{{ $article->author->name ?? 'Non défini' }}</p>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Date de Publication</h3>
                        <p class="text-gray-900">{{ $article->published_at ? $article->published_at->format('d/m/Y H:i') : 'Non définie' }}</p>
                    </div>
                    @if($article->reading_time)
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Temps de Lecture</h3>
                        <p class="text-gray-900">{{ $article->reading_time }} minutes</p>
                    </div>
                    @endif
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Créé le</h3>
                        <p class="text-gray-900">{{ $article->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                </div>
            </div>

            <!-- Featured Image -->
            @if($article->featured_image)
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <h2 class="text-lg font-semibold mb-4">Image à la Une</h2>
                <img src="{{ asset('storage/' . $article->featured_image) }}" 
                     alt="{{ $article->title }}" 
                     class="w-full max-w-md h-64 object-cover rounded-lg">
            </div>
            @endif

            <!-- Excerpt -->
            @if($article->excerpt)
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <h2 class="text-lg font-semibold mb-4">Extrait</h2>
                <p class="text-gray-700 italic">{{ $article->excerpt }}</p>
            </div>
            @endif

            <!-- Content -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <h2 class="text-lg font-semibold mb-4">Contenu</h2>
                <div class="prose max-w-none">
                    {!! $article->content !!}
                </div>
            </div>

            <!-- Tags -->
            @if($article->tags)
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <h2 class="text-lg font-semibold mb-4">Mots-clés</h2>
                <div class="flex flex-wrap gap-2">
                    @foreach(explode(',', $article->tags) as $tag)
                        <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm">{{ trim($tag) }}</span>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- SEO Information -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <h2 class="text-lg font-semibold mb-4">Informations SEO</h2>
                <div class="space-y-3">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">URL</h3>
                        <p class="text-gray-900">{{ route('article', $article->slug) }}</p>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Meta Description</h3>
                        <p class="text-gray-900">{{ $article->excerpt ? Str::limit($article->excerpt, 160) : Str::limit(strip_tags($article->content), 160) }}</p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                <h2 class="text-lg font-semibold mb-4">Actions</h2>
                <div class="flex space-x-4">
                    <a href="{{ route('admin.articles.edit', $article) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-300">
                        Modifier l'Article
                    </a>
                    <a href="{{ route('article', $article->slug) }}" target="_blank" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition duration-300">
                        Voir sur le Site
                    </a>
                    <form action="{{ route('admin.articles.destroy', $article) }}" method="POST" class="inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cet article ?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition duration-300">
                            Supprimer
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection