@extends('layouts.asu')

@section('title', 'Actualités - Association Serment Universel')

@section('head')
<!-- AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
@endsection

@section('content')
<!-- Hero Section -->
<section class="relative bg-gradient-to-br from-asu-600 to-asu-800 text-white py-20">
    <div class="absolute inset-0 bg-black/20"></div>
    
    <div class="relative z-10 max-w-6xl mx-auto px-4 text-center">
        <h1 class="text-4xl md:text-5xl font-bold mb-6" data-aos="fade-up">
            Actualités <span class="text-yellow-300">ASU</span>
        </h1>
        <p class="text-xl text-white/90 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="200">
            Restez informés de nos dernières actions, événements et initiatives pour la lutte contre le VIH/SIDA en République du Congo
        </p>
        
        <!-- Breadcrumb -->
        <nav class="mt-8" data-aos="fade-up" data-aos-delay="400">
            <ol class="flex items-center justify-center space-x-2 text-sm">
                <li><a href="/" class="text-white/80 hover:text-white transition-colors">Accueil</a></li>
                <li class="text-white/60">/</li>
                <li class="text-yellow-300">Actualités</li>
            </ol>
        </nav>
    </div>
</section>

<!-- Section Filtre et Recherche -->
<section class="py-8 bg-gray-50 border-b">
    <div class="max-w-6xl mx-auto px-4">
        <div class="flex flex-col md:flex-row gap-4 items-center justify-between">
            <!-- Barre de recherche -->
            <div class="flex-1 max-w-md" data-aos="fade-right">
                <div class="relative">
                    <input type="text" 
                           placeholder="Rechercher une actualité..." 
                           class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-asu-500 focus:border-transparent">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>
            </div>
            
            <!-- Filtres -->
            <div class="flex gap-2" data-aos="fade-left">
                <select class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-asu-500">
                    <option>Toutes les catégories</option>
                    <option>Sensibilisation</option>
                    <option>Formation</option>
                    <option>Événements</option>
                    <option>Partenariats</option>
                </select>
                
                <select class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-asu-500">
                    <option>2025</option>
                    <option>2024</option>
                    <option>2023</option>
                </select>
            </div>
        </div>
    </div>
</section>

<!-- Section Articles -->
<section class="py-20 bg-white">
    <div class="max-w-6xl mx-auto px-4">
        <!-- Article Principal -->
        <div class="mb-16" data-aos="fade-up">
            <article class="bg-white rounded-lg shadow-xl overflow-hidden">
                <div class="md:flex">
                    <div class="md:w-1/2">
                        <img src="https://images.unsplash.com/photo-1584432810601-6c7f27d2362b?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80" 
                             alt="Article principal" 
                             class="w-full h-64 md:h-full object-cover">
                    </div>
                    <div class="md:w-1/2 p-8">
                        <div class="flex items-center mb-4">
                            <span class="bg-asu-100 text-asu-700 px-3 py-1 rounded-full text-sm font-medium mr-3">À la Une</span>
                            <span class="text-gray-500 text-sm">15 Septembre 2025</span>
                        </div>
                        <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">
                            Grande campagne de sensibilisation dans les écoles de Brazzaville
                        </h2>
                        <p class="text-gray-600 mb-6 leading-relaxed">
                            Notre équipe a lancé une ambitieuse campagne de sensibilisation touchant plus de 500 élèves dans 5 établissements scolaires de la capitale. Cette initiative vise à éduquer les jeunes sur la prévention du VIH/SIDA et à briser les tabous...
                        </p>
                        <a href="#" class="inline-flex items-center bg-asu-600 hover:bg-asu-700 text-white font-semibold px-6 py-3 rounded-lg transition-colors duration-300">
                            Lire l'article complet
                            <svg class="ml-2 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </article>
        </div>
        
        <!-- Grille des Articles -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Article 1 -->
            <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="100">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1576091160550-2173dba999ef?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&q=80" 
                         alt="Journée mondiale SIDA" 
                         class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                    <div class="absolute top-4 left-4 bg-red-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        Événement
                    </div>
                </div>
                <div class="p-6">
                    <div class="text-sm text-gray-500 mb-2">1 Décembre 2024</div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-asu-600 transition-colors">
                        Journée mondiale de lutte contre le SIDA 2024
                    </h3>
                    <p class="text-gray-600 mb-4">
                        Grande mobilisation citoyenne avec plus de 1000 participants pour sensibiliser la population brazzavilloise aux enjeux de la prévention...
                    </p>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-asu-100 rounded-full flex items-center justify-center mr-2">
                                <span class="text-asu-600 font-medium text-sm">ASU</span>
                            </div>
                            <span class="text-sm text-gray-500">Équipe ASU</span>
                        </div>
                        <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                            Lire plus →
                        </a>
                    </div>
                </div>
            </article>
            
            <!-- Article 2 -->
            <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="200">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1582213782179-e0d53f98f2ca?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&q=80" 
                         alt="Formation bénévoles" 
                         class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                    <div class="absolute top-4 left-4 bg-green-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        Formation
                    </div>
                </div>
                <div class="p-6">
                    <div class="text-sm text-gray-500 mb-2">20 Novembre 2024</div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-asu-600 transition-colors">
                        Formation de 25 nouveaux bénévoles
                    </h3>
                    <p class="text-gray-600 mb-4">
                        Session intensive de formation aux techniques d'accompagnement psychosocial et de prévention pour renforcer notre équipe...
                    </p>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-asu-100 rounded-full flex items-center justify-center mr-2">
                                <span class="text-asu-600 font-medium text-sm">DR</span>
                            </div>
                            <span class="text-sm text-gray-500">Dr. Mbemba</span>
                        </div>
                        <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                            Lire plus →
                        </a>
                    </div>
                </div>
            </article>
            
            <!-- Article 3 -->
            <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="300">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1559027615-cd4628902d4a?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&q=80" 
                         alt="Partenariat" 
                         class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                    <div class="absolute top-4 left-4 bg-blue-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        Partenariat
                    </div>
                </div>
                <div class="p-6">
                    <div class="text-sm text-gray-500 mb-2">10 Novembre 2024</div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-asu-600 transition-colors">
                        Nouveau partenariat avec l'OMS Congo
                    </h3>
                    <p class="text-gray-600 mb-4">
                        Signature d'un accord de coopération avec l'Organisation Mondiale de la Santé pour renforcer nos actions de prévention...
                    </p>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-asu-100 rounded-full flex items-center justify-center mr-2">
                                <span class="text-asu-600 font-medium text-sm">JK</span>
                            </div>
                            <span class="text-sm text-gray-500">Jean Kikidi</span>
                        </div>
                        <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                            Lire plus →
                        </a>
                    </div>
                </div>
            </article>
            
            <!-- Article 4 -->
            <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="400">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1593113646773-028c64a8f1b8?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&q=80" 
                         alt="Consultation gratuite" 
                         class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                    <div class="absolute top-4 left-4 bg-purple-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        Santé
                    </div>
                </div>
                <div class="p-6">
                    <div class="text-sm text-gray-500 mb-2">5 Novembre 2024</div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-asu-600 transition-colors">
                        Journée de consultations gratuites
                    </h3>
                    <p class="text-gray-600 mb-4">
                        Organisation d'une journée de consultations médicales et de dépistage gratuits dans le quartier de Bacongo...
                    </p>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-asu-100 rounded-full flex items-center justify-center mr-2">
                                <span class="text-asu-600 font-medium text-sm">MN</span>
                            </div>
                            <span class="text-sm text-gray-500">Marie Nzala</span>
                        </div>
                        <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                            Lire plus →
                        </a>
                    </div>
                </div>
            </article>
            
            <!-- Article 5 -->
            <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="500">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&q=80" 
                         alt="Distribution matériel" 
                         class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                    <div class="absolute top-4 left-4 bg-orange-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        Distribution
                    </div>
                </div>
                <div class="p-6">
                    <div class="text-sm text-gray-500 mb-2">28 Octobre 2024</div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-asu-600 transition-colors">
                        Distribution de préservatifs dans les universités
                    </h3>
                    <p class="text-gray-600 mb-4">
                        Campagne de distribution de matériel de prévention dans les campus universitaires de Brazzaville...
                    </p>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-asu-100 rounded-full flex items-center justify-center mr-2">
                                <span class="text-asu-600 font-medium text-sm">PD</span>
                            </div>
                            <span class="text-sm text-gray-500">Paul Diaboua</span>
                        </div>
                        <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                            Lire plus →
                        </a>
                    </div>
                </div>
            </article>
            
            <!-- Article 6 -->
            <article class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 overflow-hidden group" data-aos="fade-up" data-aos-delay="600">
                <div class="relative">
                    <img src="https://images.unsplash.com/photo-1559757148-5c350d0d3c56?ixlib=rb-4.0.3&auto=format&fit=crop&w=600&q=80" 
                         alt="Réunion communautaire" 
                         class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-300">
                    <div class="absolute top-4 left-4 bg-teal-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        Communauté
                    </div>
                </div>
                <div class="p-6">
                    <div class="text-sm text-gray-500 mb-2">20 Octobre 2024</div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-asu-600 transition-colors">
                        Assemblée générale des bénéficiaires
                    </h3>
                    <p class="text-gray-600 mb-4">
                        Rencontre annuelle avec les bénéficiaires de nos programmes pour évaluer l'impact et recueillir les retours...
                    </p>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-asu-100 rounded-full flex items-center justify-center mr-2">
                                <span class="text-asu-600 font-medium text-sm">LM</span>
                            </div>
                            <span class="text-sm text-gray-500">Lydie Makosso</span>
                        </div>
                        <a href="#" class="text-asu-600 hover:text-asu-700 font-medium text-sm">
                            Lire plus →
                        </a>
                    </div>
                </div>
            </article>
        </div>
        
        <!-- Pagination -->
        <div class="mt-16 flex justify-center" data-aos="fade-up" data-aos-delay="700">
            <nav class="flex items-center space-x-1">
                <button class="px-3 py-2 text-gray-500 hover:text-gray-700 disabled:opacity-50" disabled>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>
                
                <button class="px-4 py-2 bg-asu-600 text-white rounded-lg font-medium">1</button>
                <button class="px-4 py-2 text-gray-700 hover:bg-gray-100 rounded-lg">2</button>
                <button class="px-4 py-2 text-gray-700 hover:bg-gray-100 rounded-lg">3</button>
                <span class="px-2 text-gray-500">...</span>
                <button class="px-4 py-2 text-gray-700 hover:bg-gray-100 rounded-lg">10</button>
                
                <button class="px-3 py-2 text-gray-700 hover:text-gray-900">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
            </nav>
        </div>
    </div>
</section>

<!-- Section Newsletter -->
<section class="py-16 bg-gray-50">
    <div class="max-w-4xl mx-auto px-4 text-center" data-aos="fade-up">
        <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">
            Restez informé de nos actualités
        </h2>
        <p class="text-lg text-gray-600 mb-8">
            Recevez notre newsletter mensuelle avec toutes nos dernières actions et événements
        </p>
        
        <form class="flex flex-col sm:flex-row gap-4 max-w-md mx-auto">
            <input type="email" 
                   placeholder="Votre adresse email" 
                   class="flex-1 px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-asu-500 focus:border-transparent">
            <button type="submit" 
                    class="bg-asu-600 hover:bg-asu-700 text-white font-semibold px-8 py-3 rounded-lg transition-colors duration-300">
                S'abonner
            </button>
        </form>
    </div>
</section>
@endsection

@section('scripts')
<!-- AOS JavaScript -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script>
// Initialisation d'AOS
AOS.init({
    duration: 800,
    easing: 'ease-out-cubic',
    once: true,
    offset: 50
});

// Smooth scroll pour les liens d'ancrage
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});
</script>
@endsection