#!/bin/bash

# Script pour remplacer les appels asset('storage/') par les nouvelles fonctions

echo "Remplacement des asset('storage/') par image_url() dans les vues..."

# Fonction pour remplacer dans un fichier
replace_in_file() {
    local file=$1
    
    # Remplacer asset('storage/' . $var) par image_url($var)
    sed -i "s/asset('storage\/' \. \([^)]*\))/image_url(\1)/g" "$file"
    
    # Remplacer asset(\"storage/\" . $var) par image_url($var)  
    sed -i 's/asset("storage\/" \. \([^)]*\))/image_url(\1)/g' "$file"
    
    echo "✓ Traité: $file"
}

# Traiter tous les fichiers Blade
find resources/views -name "*.blade.php" -type f | while read file; do
    if grep -q "asset('storage/" "$file" || grep -q 'asset("storage/' "$file"; then
        replace_in_file "$file"
    fi
done

echo "Remplacement terminé!"