#!/bin/bash

echo "🚀 Déploiement Laravel ASU..."

# 1. Build assets
echo "📦 Build des assets..."
npm run build

# 2. Optimiser Laravel
echo "⚡ Optimisation Laravel..."
php artisan config:cache
php artisan route:cache
php artisan view:cache

# 3. Créer archive de déploiement (sans node_modules)
echo "📁 Création archive..."
tar --exclude=node_modules \
    --exclude=.git \
    --exclude=storage/logs/* \
    --exclude=.env \
    -czf asu-deploy.tar.gz .

echo "✅ Prêt pour upload : asu-deploy.tar.gz"
echo ""
echo "📋 Instructions hébergeur :"
echo "1. Upload asu-deploy.tar.gz"
echo "2. Extraire dans public_html/"
echo "3. Configurer .env avec DB"
echo "4. Permissions : chmod 775 storage/ bootstrap/cache/"
echo "5. php artisan migrate"