<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Créer un utilisateur admin s'il n'existe pas
        User::firstOrCreate(
            ['email' => 'admin@asu-congo.org'],
            [
                'name' => 'Admin ASU',
                'password' => bcrypt('admin123'),
                'email_verified_at' => now(),
            ]
        );

        // Paramètres du site
        $this->seedSettings();
        
        // Articles/Actualités
        $this->seedArticles();
        
        // Projets
        $this->seedProjects();
        
        // Témoignages
        $this->seedTestimonials();
        
        // FAQ
        $this->seedFaqs();
        
        // Partenaires
        $this->seedPartners();
    }

    private function seedSettings()
    {
        $settings = [
            // Contact
            ['key' => 'site_name', 'value' => 'Association Serment Universel', 'type' => 'text', 'group' => 'general', 'label' => 'Nom du site'],
            ['key' => 'site_description', 'value' => 'ONG œuvrant pour la prévention du VIH/SIDA et l\'accompagnement psychosocial', 'type' => 'textarea', 'group' => 'general', 'label' => 'Description du site'],
            ['key' => 'contact_phone', 'value' => '+242 05 123 45 67', 'type' => 'text', 'group' => 'contact', 'label' => 'Téléphone'],
            ['key' => 'contact_email', 'value' => 'contact@asu-congo.org', 'type' => 'text', 'group' => 'contact', 'label' => 'Email'],
            ['key' => 'contact_address', 'value' => '123 Avenue de la Paix, Brazzaville, République du Congo', 'type' => 'textarea', 'group' => 'contact', 'label' => 'Adresse'],
            
            // Réseaux sociaux
            ['key' => 'facebook_url', 'value' => 'https://facebook.com/asu.congo', 'type' => 'text', 'group' => 'social', 'label' => 'Facebook'],
            ['key' => 'youtube_url', 'value' => 'https://youtube.com/@asu-congo', 'type' => 'text', 'group' => 'social', 'label' => 'YouTube'],
            ['key' => 'instagram_url', 'value' => 'https://instagram.com/asu.congo', 'type' => 'text', 'group' => 'social', 'label' => 'Instagram'],
            
            // Statistiques
            ['key' => 'years_active', 'value' => '27', 'type' => 'number', 'group' => 'stats', 'label' => 'Années d\'activité'],
            ['key' => 'communities_served', 'value' => '150', 'type' => 'number', 'group' => 'stats', 'label' => 'Communautés servies'],
            ['key' => 'people_helped', 'value' => '50000', 'type' => 'number', 'group' => 'stats', 'label' => 'Personnes aidées'],
            ['key' => 'volunteers', 'value' => '250', 'type' => 'number', 'group' => 'stats', 'label' => 'Bénévoles'],
        ];

        foreach ($settings as $setting) {
            \App\Models\Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting + ['order' => 0, 'is_public' => true]
            );
        }
    }

    private function seedArticles()
    {
        $articles = [
            [
                'title' => 'Grande campagne de sensibilisation dans les écoles de Brazzaville',
                'excerpt' => 'Notre équipe a sensibilisé plus de 500 élèves sur la prévention du VIH/SIDA',
                'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit...',
                'author' => 'Équipe ASU',
                'category' => 'sensibilisation',
                'status' => 'published',
                'is_featured' => true,
                'published_at' => now()->subDays(5),
            ],
            [
                'title' => 'Formation de 25 nouveaux bénévoles',
                'excerpt' => 'Session intensive de formation aux techniques d\'accompagnement psychosocial',
                'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit...',
                'author' => 'Dr. Mbemba',
                'category' => 'formation',
                'status' => 'published',
                'published_at' => now()->subDays(10),
            ],
            [
                'title' => 'Journée mondiale de lutte contre le SIDA 2024',
                'excerpt' => 'Grande mobilisation citoyenne avec plus de 1000 participants',
                'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit...',
                'author' => 'Équipe ASU',
                'category' => 'evenement',
                'status' => 'published',
                'published_at' => now()->subDays(15),
            ],
        ];

        foreach ($articles as $article) {
            \App\Models\Article::create($article);
        }
    }

    private function seedProjects()
    {
        $projects = [
            [
                'title' => 'Éducation Préventive dans les Écoles',
                'description' => 'Programme de sensibilisation dans 50 établissements scolaires',
                'status' => 'in_progress',
                'budget' => 15000,
                'start_date' => '2024-01-01',
                'end_date' => '2026-12-31',
                'progress_percentage' => 65,
                'is_featured' => true,
            ],
            [
                'title' => 'Centre d\'Accompagnement Psychosocial',
                'description' => 'Construction d\'un centre dédié à l\'accompagnement',
                'status' => 'planned',
                'budget' => 45000,
                'start_date' => '2025-06-01',
                'end_date' => '2027-12-31',
                'progress_percentage' => 0,
            ],
            [
                'title' => 'Formation des Leaders Communautaires',
                'description' => 'Programme de formation de 100 leaders communautaires',
                'status' => 'completed',
                'budget' => 8000,
                'start_date' => '2022-01-01',
                'end_date' => '2024-06-30',
                'progress_percentage' => 100,
            ],
        ];

        foreach ($projects as $project) {
            \App\Models\Project::create($project);
        }
    }

    private function seedTestimonials()
    {
        $testimonials = [
            [
                'name' => 'Marie K.',
                'title' => 'Bénéficiaire depuis 2022',
                'content' => 'Grâce à l\'ASU, j\'ai appris à vivre sereinement avec ma séropositivité.',
                'type' => 'beneficiary',
                'is_featured' => true,
            ],
            [
                'name' => 'Jean-Paul M.',
                'title' => 'Père de famille',
                'content' => 'L\'éducation reçue m\'a permis de protéger ma famille.',
                'type' => 'beneficiary',
            ],
            [
                'name' => 'Sarah L.',
                'title' => 'Bénévole depuis 2021',
                'content' => 'Être bénévole à l\'ASU m\'a appris l\'empathie.',
                'type' => 'volunteer',
            ],
        ];

        foreach ($testimonials as $testimonial) {
            \App\Models\Testimonial::create($testimonial);
        }
    }

    private function seedFaqs()
    {
        $faqs = [
            [
                'question' => 'Comment puis-je bénéficier de vos services ?',
                'answer' => 'Nos services sont gratuits et ouverts à tous. Contactez-nous directement.',
                'category' => 'services',
            ],
            [
                'question' => 'Vos services sont-ils confidentiels ?',
                'answer' => 'Absolument. La confidentialité est au cœur de notre approche.',
                'category' => 'services',
            ],
            [
                'question' => 'Comment devenir bénévole ?',
                'answer' => 'Contactez-nous pour participer à une session d\'orientation.',
                'category' => 'volunteering',
            ],
        ];

        foreach ($faqs as $faq) {
            \App\Models\Faq::create($faq);
        }
    }

    private function seedPartners()
    {
        $partners = [
            [
                'name' => 'Ministère de la Santé',
                'type' => 'government',
                'partnership_level' => 'strategic',
                'is_featured' => true,
            ],
            [
                'name' => 'OMS Congo',
                'type' => 'international',
                'partnership_level' => 'strategic',
                'is_featured' => true,
            ],
            [
                'name' => 'UNICEF',
                'type' => 'international',
                'partnership_level' => 'operational',
            ],
        ];

        foreach ($partners as $partner) {
            \App\Models\Partner::create($partner);
        }
    }
}
