<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('text'); // text, textarea, number, boolean, json, file
            $table->string('group')->default('general'); // general, contact, social, appearance, seo
            $table->string('label');
            $table->text('description')->nullable();
            $table->json('options')->nullable(); // Pour les select, checkbox, etc.
            $table->integer('order')->default(0);
            $table->boolean('is_public')->default(false); // Si accessible depuis le front
            $table->timestamps();
            
            $table->index(['group', 'order']);
            $table->index('is_public');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
