<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('partners', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('logo_path')->nullable();
            $table->string('website_url')->nullable();
            $table->enum('type', ['institutional', 'ngo', 'private', 'academic', 'international', 'government'])->default('institutional');
            $table->enum('partnership_level', ['strategic', 'operational', 'financial', 'technical', 'occasional'])->default('operational');
            $table->date('partnership_start')->nullable();
            $table->date('partnership_end')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->integer('order')->default(0);
            $table->string('contact_person')->nullable();
            $table->string('contact_email')->nullable();
            $table->string('contact_phone')->nullable();
            $table->json('collaboration_areas')->nullable(); // Domaines de collaboration
            $table->json('meta')->nullable();
            $table->timestamps();
            
            $table->index(['is_active', 'type']);
            $table->index(['is_featured', 'order']);
            $table->index('partnership_level');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('partners');
    }
};
