<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('file_path');
            $table->string('file_name');
            $table->string('file_type'); // pdf, doc, docx, etc.
            $table->integer('file_size'); // en bytes
            $table->enum('category', ['report', 'guide', 'brochure', 'form', 'policy', 'manual', 'other'])->default('other');
            $table->string('icon_color')->default('blue'); // Couleur de l'icône
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_public')->default(true);
            $table->integer('download_count')->default(0);
            $table->date('document_date')->nullable();
            $table->string('version')->nullable();
            $table->json('tags')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
            
            $table->index(['is_public', 'category']);
            $table->index('is_featured');
            $table->index('document_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};
