<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('galleries', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('image_path');
            $table->string('thumbnail_path')->nullable();
            $table->enum('type', ['image', 'video'])->default('image');
            $table->string('video_url')->nullable(); // Pour YouTube, Vimeo etc.
            $table->string('alt_text')->nullable();
            $table->enum('category', ['events', 'training', 'community', 'projects', 'partnerships', 'general'])->default('general');
            $table->date('event_date')->nullable();
            $table->string('location')->nullable();
            $table->json('tags')->nullable(); // Tags pour le filtrage
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_published')->default(true);
            $table->integer('order')->default(0);
            $table->integer('views')->default(0);
            $table->json('meta')->nullable();
            $table->timestamps();
            
            $table->index(['is_published', 'category']);
            $table->index(['is_featured', 'order']);
            $table->index('type');
            $table->index('event_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('galleries');
    }
};
