<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('title')->nullable(); // Fonction/statut de la personne
            $table->text('content');
            $table->string('avatar')->nullable();
            $table->enum('type', ['beneficiary', 'volunteer', 'partner', 'staff'])->default('beneficiary');
            $table->string('location')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_published')->default(true);
            $table->integer('order')->default(0);
            $table->date('testimonial_date')->nullable();
            $table->json('meta')->nullable(); // Métadonnées supplémentaires
            $table->timestamps();
            
            $table->index(['is_published', 'is_featured']);
            $table->index('type');
            $table->index('order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testimonials');
    }
};
