<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Configuration ASU (Association Serment Universel)
    |--------------------------------------------------------------------------
    |
    | Cette configuration contient toutes les informations spécifiques
    | à l'Association Serment Universel.
    |
    */

    'name' => 'Association Serment Universel',
    'abbreviation' => 'ASU',
    'founded_year' => 1998,
    'country' => 'République Démocratique du Congo',
    'city' => 'Kinshasa',

    /*
    |--------------------------------------------------------------------------
    | Réseaux sociaux
    |--------------------------------------------------------------------------
    */
    'social' => [
        'facebook' => env('ASU_FACEBOOK_URL', 'https://facebook.com/asu.congo'),
        'youtube' => env('ASU_YOUTUBE_URL', 'https://youtube.com/@asu-congo'),
        'instagram' => env('ASU_INSTAGRAM_URL', 'https://instagram.com/asu.congo'),
        'twitter' => env('ASU_TWITTER_URL', 'https://twitter.com/asu_congo'),
        'linkedin' => env('ASU_LINKEDIN_URL', 'https://linkedin.com/company/asu-congo'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Contact
    |--------------------------------------------------------------------------
    */
    'contact' => [
        'email' => env('ASU_EMAIL', 'contact@asu-congo.org'),
        'phone' => env('ASU_PHONE', '+242 123 456 789'),
        'address' => env('ASU_ADDRESS', 'Brazzaville, République du Congo'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Mission et valeurs
    |--------------------------------------------------------------------------
    */
    'mission' => 'Placer l\'humain au cœur de l\'action solidaire',
    
    'values' => [
        'Dignité pour tous',
        'Force du collectif',
        'Espoir et solidarité',
        'Accompagnement psychosocial',
        'Prévention et soutien',
    ],

    /*
    |--------------------------------------------------------------------------
    | Domaines d'action
    |--------------------------------------------------------------------------
    */
    'actions' => [
        'prevention_vih_sida' => [
            'title' => 'Prévention VIH/SIDA',
            'description' => 'Sensibilisation et prévention auprès des communautés',
            'icon' => 'medical-cross',
        ],
        'accompagnement_psychosocial' => [
            'title' => 'Accompagnement psychosocial',
            'description' => 'Soutien psychologique aux personnes vulnérables',
            'icon' => 'heart',
        ],
        'soutien_communautaire' => [
            'title' => 'Soutien communautaire',
            'description' => 'Renforcement des liens communautaires',
            'icon' => 'users',
        ],
        'education_sante' => [
            'title' => 'Éducation à la santé',
            'description' => 'Formation et sensibilisation en santé publique',
            'icon' => 'book-open',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Statistiques
    |--------------------------------------------------------------------------
    */
    'stats' => [
        'years_active' => date('Y') - 1998,
        'communities_served' => 50,
        'people_helped' => 10000,
        'volunteers' => 150,
        'partners' => 25,
    ],

    /*
    |--------------------------------------------------------------------------
    | Configuration SEO
    |--------------------------------------------------------------------------
    */
    'seo' => [
        'default_title' => 'Association Serment Universel - ASU Congo',
        'default_description' => 'Association Serment Universel œuvre depuis 1998 pour l\'accompagnement psychosocial, la prévention et le soutien auprès des communautés du Congo.',
        'keywords' => 'ASU, Congo, VIH, SIDA, prévention, accompagnement psychosocial, ONG, santé, communauté, Kinshasa',
        'author' => 'Association Serment Universel',
    ],

    /*
    |--------------------------------------------------------------------------
    | Configuration des médias
    |--------------------------------------------------------------------------
    */
    'media' => [
        'logo' => 'images/asu-logo.png',
        'og_image' => 'images/asu-og-image.jpg',
        'favicon' => 'favicon.ico',
        'apple_touch_icon' => 'images/apple-touch-icon.png',
    ],

    /*
    |--------------------------------------------------------------------------
    | Configuration des couleurs (pour Tailwind)
    |--------------------------------------------------------------------------
    */
    'colors' => [
        'primary' => '#dc2626', // Rouge ASU
        'secondary' => '#22c55e', // Vert Congo
        'accent' => '#f59e0b', // Orange accent
    ],

];