<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function dashboard()
    {
        $stats = [
            'articles' => \App\Models\Article::count(),
            'projects' => \App\Models\Project::count(),
            'testimonials' => \App\Models\Testimonial::count(),
            'gallery_items' => \App\Models\Gallery::count(),
            'documents' => \App\Models\Document::count(),
            'faqs' => \App\Models\Faq::count(),
            'partners' => \App\Models\Partner::count(),
            'pages' => \App\Models\Page::count(),
        ];

        return view('admin.dashboard', compact('stats'));
    }
}